package org.eclipse.incquery.viewers.runtime.model.patterns.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2edgeMatch;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2edgeMatcher;

/**
 * A pattern-specific query specification that can instantiate Param2edgeMatcher in a type-safe way.
 * 
 * @see Param2edgeMatcher
 * @see Param2edgeMatch
 * 
 */
@SuppressWarnings("all")
public final class Param2edgeQuerySpecification extends BaseGeneratedEMFQuerySpecification<Param2edgeMatcher> {
  private Param2edgeQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static Param2edgeQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected Param2edgeMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return Param2edgeMatcher.on(engine);
  }
  
  @Override
  public Param2edgeMatch newEmptyMatch() {
    return Param2edgeMatch.newEmptyMatch();
  }
  
  @Override
  public Param2edgeMatch newMatch(final Object... parameters) {
    return Param2edgeMatch.newMatch((java.lang.Object) parameters[0], (java.lang.Object) parameters[1], (org.eclipse.incquery.viewmodel.traceability.Trace) parameters[2], (org.eclipse.incquery.viewers.runtime.model.Edge) parameters[3]);
  }
  
  private static class LazyHolder {
    private final static Param2edgeQuerySpecification INSTANCE = make();
    
    public static Param2edgeQuerySpecification make() {
      return new Param2edgeQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static Param2edgeQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.viewers.runtime.model.patterns.param2edge";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("source","target","trace","edge");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("source", "java.lang.Object"),new PParameter("target", "java.lang.Object"),new PParameter("trace", "org.eclipse.incquery.viewmodel.traceability.Trace"),new PParameter("edge", "org.eclipse.incquery.viewers.runtime.model.Edge"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		PVariable var_edge = body.getOrCreateVariableByName("edge");
      		new TypeConstraint(body, new FlatTuple(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Edge")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, "source"),
      		   new ExportedParameter(body, var_target, "target"),
      		   new ExportedParameter(body, var_trace, "trace"),
      		   new ExportedParameter(body, var_edge, "edge")
      		));
      		// 	Trace.params(trace, source)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "params")));
      		new Equality(body, var__virtual_0_, var_source);
      		// 	Trace.params(trace, target)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "params")));
      		new Equality(body, var__virtual_1_, var_target);
      		// 	Trace.targets(trace, edge)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "targets")));
      		new Equality(body, var__virtual_2_, var_edge);
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		PVariable var_edge = body.getOrCreateVariableByName("edge");
      		new TypeConstraint(body, new FlatTuple(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Edge")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, "source"),
      		   new ExportedParameter(body, var_target, "target"),
      		   new ExportedParameter(body, var_trace, "trace"),
      		   new ExportedParameter(body, var_edge, "edge")
      		));
      		// 	Trace.objects(trace, source)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "objects")));
      		new Equality(body, var__virtual_0_, var_source);
      		// 	Trace.params(trace, target)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "params")));
      		new Equality(body, var__virtual_1_, var_target);
      		// 	Trace.targets(trace, edge)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "targets")));
      		new Equality(body, var__virtual_2_, var_edge);
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		PVariable var_edge = body.getOrCreateVariableByName("edge");
      		new TypeConstraint(body, new FlatTuple(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Edge")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, "source"),
      		   new ExportedParameter(body, var_target, "target"),
      		   new ExportedParameter(body, var_trace, "trace"),
      		   new ExportedParameter(body, var_edge, "edge")
      		));
      		// 	Trace.params(trace, source)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "params")));
      		new Equality(body, var__virtual_0_, var_source);
      		// 	Trace.objects(trace, target)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "objects")));
      		new Equality(body, var__virtual_1_, var_target);
      		// 	Trace.targets(trace, edge)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "targets")));
      		new Equality(body, var__virtual_2_, var_edge);
      		bodies.add(body);
      	}
      	{
      		PBody body = new PBody(this);
      		PVariable var_source = body.getOrCreateVariableByName("source");
      		PVariable var_target = body.getOrCreateVariableByName("target");
      		PVariable var_trace = body.getOrCreateVariableByName("trace");
      		PVariable var_edge = body.getOrCreateVariableByName("edge");
      		new TypeConstraint(body, new FlatTuple(var_edge), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/notation/1.0", "Edge")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_source, "source"),
      		   new ExportedParameter(body, var_target, "target"),
      		   new ExportedParameter(body, var_trace, "trace"),
      		   new ExportedParameter(body, var_edge, "edge")
      		));
      		// 	Trace.objects(trace, source)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "objects")));
      		new Equality(body, var__virtual_0_, var_source);
      		// 	Trace.objects(trace, target)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_1_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "objects")));
      		new Equality(body, var__virtual_1_, var_target);
      		// 	Trace.targets(trace, edge)
      		new TypeConstraint(body, new FlatTuple(var_trace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace")));
      		PVariable var__virtual_2_ = body.getOrCreateVariableByName(".virtual{2}");
      		new TypeConstraint(body, new FlatTuple(var_trace, var__virtual_2_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://org.eclipse.incquery/viewmodel/traceability/1.0", "Trace", "targets")));
      		new Equality(body, var__virtual_2_, var_edge);
      		bodies.add(body);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
