/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.evm.api.Agenda;
import org.eclipse.incquery.runtime.evm.api.RuleInstance;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.api.event.EventRealm;
import org.eclipse.incquery.runtime.evm.specific.resolver.ArbitraryOrderConflictResolver;

public class RuleBase {
    private final EventRealm eventRealm;
    private final Table<RuleSpecification<?>, EventFilter<?>, RuleInstance<?>> ruleInstanceTable;
    private final Agenda agenda;
    private Logger logger;

    protected RuleBase(EventRealm eventRealm) {
        this.eventRealm = (EventRealm)Preconditions.checkNotNull((Object)eventRealm, (Object)"Cannot create RuleBase with null event source");
        this.ruleInstanceTable = HashBasedTable.create();
        this.agenda = new Agenda(this, new ArbitraryOrderConflictResolver());
        this.logger = Logger.getLogger((String)this.toString());
    }

    protected <EventAtom> RuleInstance<EventAtom> instantiateRule(RuleSpecification<EventAtom> specification, EventFilter<EventAtom> filter) {
        Preconditions.checkNotNull(specification, (Object)"Cannot instantiate null rule!");
        Preconditions.checkNotNull(filter, (Object)"Cannot instantiate rule with null filter!");
        if (this.ruleInstanceTable.containsRow(specification)) {
            return this.findInstance(specification, filter);
        }
        RuleInstance<EventAtom> rule = specification.instantiateRule(this.eventRealm, filter);
        rule.addActivationNotificationListener(this.agenda.getActivationListener(), true);
        this.ruleInstanceTable.put(specification, filter, rule);
        return rule;
    }

    protected <EventAtom> boolean removeRule(RuleInstance<EventAtom> instance) {
        Preconditions.checkNotNull(instance, (Object)"Cannot remove null rule instance!");
        return this.removeRule(instance.getSpecification(), instance.getFilter());
    }

    protected <EventAtom> boolean removeRule(RuleSpecification<EventAtom> specification, EventFilter<EventAtom> filter) {
        Preconditions.checkNotNull(specification, (Object)"Cannot remove null rule specification!");
        Preconditions.checkNotNull(filter, (Object)"Cannot remove instance for null filter");
        RuleInstance<EventAtom> instance = this.findInstance(specification, filter);
        if (instance != null) {
            instance.dispose();
            this.ruleInstanceTable.remove(specification, filter);
            return true;
        }
        return false;
    }

    protected void dispose() {
        for (RuleInstance instance : this.ruleInstanceTable.values()) {
            instance.dispose();
        }
    }

    public EventRealm getEventRealm() {
        return this.eventRealm;
    }

    public Multimap<RuleSpecification<?>, EventFilter<?>> getRuleSpecificationMultimap() {
        HashMultimap ruleMap = HashMultimap.create();
        Map rowMap = this.ruleInstanceTable.rowMap();
        for (Map.Entry entry : rowMap.entrySet()) {
            ruleMap.putAll((Object)((RuleSpecification)entry.getKey()), ((Map)entry.getValue()).keySet());
        }
        return ruleMap;
    }

    public Set<RuleInstance<?>> getRuleInstances() {
        return ImmutableSet.copyOf((Collection)this.ruleInstanceTable.values());
    }

    public <EventAtom> RuleInstance<EventAtom> getInstance(RuleSpecification<EventAtom> specification, EventFilter<EventAtom> filter) {
        Preconditions.checkNotNull(specification, (Object)"Cannot get instance for null specification");
        Preconditions.checkNotNull(filter, (Object)"Cannot get instance for null filter");
        return this.findInstance(specification, filter);
    }

    private <EventAtom> RuleInstance<EventAtom> findInstance(RuleSpecification<EventAtom> specification, EventFilter<EventAtom> filter) {
        return (RuleInstance)this.ruleInstanceTable.get(specification, filter);
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

