/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.ConflictResolver;
import org.eclipse.incquery.runtime.evm.api.Context;
import org.eclipse.incquery.runtime.evm.api.RuleBase;
import org.eclipse.incquery.runtime.evm.api.RuleInstance;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.event.ActivationState;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.api.event.EventRealm;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;

public class RuleEngine {
    private static final String FILTER_MUST_BE_SPECIFIED = "Filter must be specified";
    private static final String RULE_SPECIFICATION_MUST_BE_SPECIFIED = "Rule specification must be specified!";
    private RuleBase ruleBase;

    protected RuleEngine(RuleBase ruleBase) {
        this.ruleBase = (RuleBase)Preconditions.checkNotNull((Object)ruleBase, (Object)"Cannot create rule engine with null ruleBase!");
    }

    public static RuleEngine create(RuleBase ruleBase) {
        return new RuleEngine(ruleBase);
    }

    public void setConflictResolver(ConflictResolver<?> conflictResolver) {
        Preconditions.checkNotNull(conflictResolver, (Object)"Conflict resolver cannot be null!");
        this.ruleBase.getAgenda().setConflictResolver(conflictResolver);
    }

    public <EventAtom> void addRule(RuleSpecification<EventAtom> specification) {
        this.addRule(specification, false, specification.createEmptyFilter());
    }

    public <EventAtom> void addRule(RuleSpecification<EventAtom> specification, boolean fireNow) {
        this.addRule(specification, fireNow, specification.createEmptyFilter());
    }

    public <EventAtom> void addRule(RuleSpecification<EventAtom> specification, boolean fireNow, EventFilter<EventAtom> filter) {
        Preconditions.checkNotNull(filter, (Object)FILTER_MUST_BE_SPECIFIED);
        Preconditions.checkNotNull(specification, (Object)RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        RuleInstance<EventAtom> instance = this.ruleBase.instantiateRule(specification, filter);
        if (fireNow) {
            this.fireActivations(instance);
        }
    }

    public Multimap<ActivationState, Activation<?>> getActivations() {
        return ImmutableMultimap.copyOf(this.ruleBase.getAgenda().getActivations());
    }

    public Activation<?> getNextActivation() {
        return this.ruleBase.getAgenda().getNextActivation();
    }

    public Set<Activation<?>> getConflictingActivations() {
        return ImmutableSet.copyOf(this.ruleBase.getAgenda().getConflictingActivations());
    }

    public Set<Activation<?>> getActivations(IncQueryActivationStateEnum state) {
        Preconditions.checkNotNull((Object)state, (Object)"Activation state must be specified!");
        return ImmutableSet.copyOf(this.ruleBase.getAgenda().getActivations(state));
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification) {
        return this.getActivations(specification, specification.createEmptyFilter());
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification, EventFilter<EventAtom> filter) {
        Preconditions.checkNotNull(specification, (Object)RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        Preconditions.checkNotNull(filter, (Object)FILTER_MUST_BE_SPECIFIED);
        return ImmutableSet.copyOf(this.ruleBase.getInstance(specification, filter).getAllActivations());
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification, ActivationState state) {
        return this.getActivations(specification, specification.createEmptyFilter(), state);
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification, EventFilter<EventAtom> filter, ActivationState state) {
        Preconditions.checkNotNull(specification, (Object)RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        Preconditions.checkNotNull((Object)state, (Object)"Activation state must be specified!");
        Preconditions.checkNotNull(filter, (Object)FILTER_MUST_BE_SPECIFIED);
        return ImmutableSet.copyOf(this.ruleBase.getInstance(specification, filter).getActivations(state));
    }

    protected <EventAtom> void fireActivations(RuleInstance<EventAtom> instance) {
        Context context = new Context();
        for (Activation<EventAtom> act : instance.getAllActivations()) {
            act.fire(context);
        }
    }

    public Set<RuleSpecification<?>> getRuleSpecifications() {
        return ImmutableSet.copyOf((Collection)this.ruleBase.getRuleSpecificationMultimap().keySet());
    }

    public Multimap<RuleSpecification<?>, EventFilter<?>> getRuleSpecificationMultimap() {
        return ImmutableMultimap.copyOf(this.ruleBase.getRuleSpecificationMultimap());
    }

    public <EventAtom> boolean removeRule(RuleSpecification<EventAtom> specification) {
        Preconditions.checkNotNull(specification, (Object)RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        return this.ruleBase.removeRule(specification, specification.createEmptyFilter());
    }

    public <EventAtom> boolean removeRule(RuleSpecification<EventAtom> specification, EventFilter<EventAtom> filter) {
        Preconditions.checkNotNull(specification, (Object)RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        Preconditions.checkNotNull(filter, (Object)FILTER_MUST_BE_SPECIFIED);
        return this.ruleBase.removeRule(specification, filter);
    }

    protected RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public EventRealm getEventSource() {
        return this.ruleBase.getEventRealm();
    }

    public Logger getLogger() {
        return this.ruleBase.getLogger();
    }

    public void dispose() {
        this.ruleBase.dispose();
    }
}

