/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.resolver;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.ConflictResolver;
import org.eclipse.incquery.runtime.evm.api.ConflictSet;

public class ArbitraryOrderConflictResolver
implements ConflictResolver<ArbitraryConflictSet> {
    @Override
    public ArbitraryConflictSet createConflictSet() {
        return new ArbitraryConflictSet(this);
    }

    public static final class ArbitraryConflictSet
    implements ConflictSet {
        private final Set<Activation<?>> container;
        private final ArbitraryOrderConflictResolver resolver;

        protected ArbitraryConflictSet(ArbitraryOrderConflictResolver resolver) {
            this.resolver = resolver;
            this.container = Sets.newHashSet();
        }

        @Override
        public Activation<?> getNextActivation() {
            if (!this.container.isEmpty()) {
                return this.container.iterator().next();
            }
            return null;
        }

        @Override
        public boolean addActivation(Activation<?> activation) {
            return this.container.add(activation);
        }

        @Override
        public boolean removeActivation(Activation<?> activation) {
            return this.container.remove(activation);
        }

        public ArbitraryOrderConflictResolver getConflictResolver() {
            return this.resolver;
        }

        @Override
        public Set<Activation<?>> getNextActivations() {
            return Collections.unmodifiableSet(this.container);
        }

        @Override
        public Set<Activation<?>> getConflictingActivations() {
            return Collections.unmodifiableSet(this.container);
        }
    }
}

