/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal.matcherbuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.runtime.internal.matcherbuilder.EPMBodyToPSystem;
import org.eclipse.incquery.runtime.internal.matcherbuilder.XBaseEvaluator;
import org.eclipse.incquery.runtime.rete.boundary.AbstractEvaluator;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred.BaseTypeSafePredicateCheck;
import org.eclipse.incquery.runtime.rete.tuple.FlatTuple;
import org.eclipse.xtext.xbase.XExpression;

public class XBaseCheck<StubHandle>
extends BaseTypeSafePredicateCheck<Pattern, StubHandle> {
    private final XExpression xExpression;
    private final EPMBodyToPSystem<StubHandle, ?> pGraph;
    private final Pattern pattern;

    public XBaseCheck(EPMBodyToPSystem<StubHandle, ?> pGraph, XExpression xExpression, Pattern pattern) {
        super(pGraph.pSystem, XBaseCheck.getExternalPNodeReferencesOfXExpression(pGraph, xExpression));
        this.pGraph = pGraph;
        this.xExpression = xExpression;
        this.pattern = pattern;
    }

    protected Stub<StubHandle> doCheckOn(Stub<StubHandle> stub) throws RetePatternBuildException {
        HashSet<Integer> affectedIndices = new HashSet<Integer>();
        HashMap<String, Integer> tupleNameMap = new HashMap<String, Integer>();
        Set variables = CorePatternLanguageHelper.getReferencedPatternVariablesOfXExpression((XExpression)this.xExpression);
        for (Variable variable : variables) {
            PVariable pNode = this.pGraph.getPNode(variable);
            Integer position = (Integer)stub.getVariablesIndex().get(pNode);
            tupleNameMap.put(variable.getSimpleName(), position);
            affectedIndices.add(position);
        }
        int[] indices = new int[affectedIndices.size()];
        int k = 0;
        for (Integer index : affectedIndices) {
            indices[k++] = index;
        }
        XBaseEvaluator evaluator = new XBaseEvaluator(this.xExpression, tupleNameMap, this.pattern);
        return this.buildable.buildPredicateChecker((AbstractEvaluator)evaluator, null, indices, stub);
    }

    private static Set<PVariable> getExternalPNodeReferencesOfXExpression(EPMBodyToPSystem<?, ?> pGraph, XExpression xExpression) {
        HashSet<PVariable> result = new HashSet<PVariable>();
        Set variables = CorePatternLanguageHelper.getReferencedPatternVariablesOfXExpression((XExpression)xExpression);
        for (Variable variable : variables) {
            result.add(pGraph.getPNode(variable));
        }
        return result;
    }

    protected String toStringRest() {
        return String.valueOf(new FlatTuple(new ArrayList(this.getAffectedVariables()).toArray()).toString()) + "|=" + this.xExpression.toString();
    }

    protected void doReplaceVariable(PVariable obsolete, PVariable replacement) {
    }
}

