package org.eclipse.incquery.testing.example;

import com.google.inject.Inject;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.snapshot.EIQSnapshot.EIQSnapshotFactory;
import org.eclipse.incquery.snapshot.EIQSnapshot.IncQuerySnapshot;
import org.eclipse.incquery.snapshot.EIQSnapshot.MatchSetRecord;
import org.eclipse.incquery.testing.core.ModelLoadHelper;
import org.eclipse.incquery.testing.core.SnapshotHelper;
import org.eclipse.incquery.testing.core.TestExecutor;
import org.eclipse.incquery.testing.core.injector.EMFPatternLanguageInjectorProvider;
import org.eclipse.xtext.junit4.InjectWith;
import org.eclipse.xtext.junit4.XtextRunner;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value = XtextRunner.class)
@InjectWith(value = EMFPatternLanguageInjectorProvider.class)
@SuppressWarnings("all")
public class ExampleIncQueryFunctionalTest {
  @Inject
  private TestExecutor _testExecutor;
  
  @Inject
  private ModelLoadHelper _modelLoadHelper;
  
  @Inject
  private SnapshotHelper _snapshotHelper;
  
  @Inject
  private ParseHelper parseHelper;
  
  public PatternModel testInput() {
    try {
      EObject _parse = this.parseHelper.parse("\n\t\t\timport \"http://www.eclipse.org/viatra2/patternlanguage/core/PatternLanguage\"\n\n\t\t\tpattern resolutionTest(Name) = {\n\t\t\t\tPattern(Name);\n\t\t\t}\n\t\t");
      return ((PatternModel) _parse);
    } catch (Exception _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public IncQuerySnapshot prepareSelfTest(final PatternModel patternModel) {
    this._snapshotHelper.prepareSnapshotMatcherFactories();
    final IncQueryMatcher<? extends IPatternMatch> matcher = this._modelLoadHelper.initializeMatcherFromModel(patternModel, patternModel, "resolutionTest");
    final IncQuerySnapshot snapshot = EIQSnapshotFactory.eINSTANCE.createIncQuerySnapshot();
    this._snapshotHelper.saveMatchesToSnapshot(matcher, snapshot);
    return snapshot;
  }
  
  @Test
  public void basicTest() {
    final PatternModel model = this.testInput();
    this._snapshotHelper.prepareSnapshotMatcherFactories();
    final IncQueryMatcher<? extends IPatternMatch> matcher = this._modelLoadHelper.initializeMatcherFromModel(model, model, "resolutionTest");
    final IncQuerySnapshot snapshot = EIQSnapshotFactory.eINSTANCE.createIncQuerySnapshot();
    final MatchSetRecord expected = this._snapshotHelper.saveMatchesToSnapshot(matcher, snapshot);
    final HashSet<Object> results = this._testExecutor.compareResultSets(matcher, expected);
    HashSet<Object> _newHashSet = CollectionLiterals.<Object>newHashSet();
    Assert.assertArrayEquals(((Object[])Conversions.unwrapArray(_newHashSet, Object.class)), ((Object[])Conversions.unwrapArray(results, Object.class)));
  }
  
  @Test
  public void shortTest() {
    final PatternModel patternModel = this.testInput();
    final IncQuerySnapshot snapshot = this.prepareSelfTest(patternModel);
    this._testExecutor.assertMatchResults(patternModel, snapshot);
  }
}
