/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser;

import java.util.HashMap;
import java.util.Map;
import opencard.opt.util.TLV;
import opencard.opt.util.Tag;
import org.eclipse.keyple.command.AbstractApduResponseParser;
import org.eclipse.keyple.seproxy.message.ApduResponse;
import org.eclipse.keyple.util.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetDataFciRespPars
extends AbstractApduResponseParser {
    protected static final Logger logger = LoggerFactory.getLogger(GetDataFciRespPars.class);
    private static final Map<Integer, AbstractApduResponseParser.StatusProperties> STATUS_TABLE;
    private static final int[] BUFFER_SIZE_INDICATOR_TO_BUFFER_SIZE;
    private static final Tag TAG_FCI_TEMPLATE;
    private static final Tag TAG_DF_NAME;
    private static final Tag TAG_FCI_PROPRIETARY_TEMPLATE;
    private static final Tag TAG_FCI_ISSUER_DISCRETIONARY_DATA;
    private static final Tag TAG_APPLICATION_SERIAL_NUMBER;
    private static final Tag TAG_DISCRETIONARY_DATA;
    private boolean isDfInvalidated = false;
    private boolean isValidCalypsoFCI = false;
    private byte[] dfName = null;
    private byte[] applicationSN = null;
    private byte[] discretionaryData = null;
    private byte siBufferSizeIndicator = 0;
    private byte siPlatform = 0;
    private byte siApplicationType = 0;
    private byte siApplicationSubtype = 0;
    private byte siSoftwareIssuer = 0;
    private byte siSoftwareVersion = 0;
    private byte siSoftwareRevision = 0;
    private static final byte APP_TYPE_WITH_CALYPSO_PIN = 1;
    private static final byte APP_TYPE_WITH_CALYPSO_SV = 2;
    private static final byte APP_TYPE_RATIFICATION_COMMAND_REQUIRED = 4;
    private static final byte APP_TYPE_CALYPSO_REV_32_MODE = 8;

    protected Map<Integer, AbstractApduResponseParser.StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    public GetDataFciRespPars(ApduResponse selectApplicationResponse) {
        if (selectApplicationResponse.getStatusCode() == 25219) {
            logger.debug("The response to the select application command status word indicates that the DF has been invalidated.");
            this.isDfInvalidated = true;
        }
        try {
            TLV pTag;
            TLV cTag = new TLV(selectApplicationResponse.getDataOut());
            if (cTag != null && cTag.tag().equals((Object)TAG_FCI_TEMPLATE) && (pTag = cTag.findTag(TAG_DF_NAME, null)) != null) {
                this.dfName = pTag.valueAsByteArray();
                if (logger.isDebugEnabled()) {
                    logger.debug("DF Name = {}", (Object)ByteArrayUtils.toHex((byte[])this.dfName));
                }
                if ((cTag = cTag.findTag(TAG_FCI_PROPRIETARY_TEMPLATE, null)) != null && (cTag = cTag.findTag(TAG_FCI_ISSUER_DISCRETIONARY_DATA, null)) != null && (pTag = cTag.findTag(TAG_APPLICATION_SERIAL_NUMBER, null)) != null) {
                    this.applicationSN = pTag.valueAsByteArray();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Application Serial Number = {}", (Object)ByteArrayUtils.toHex((byte[])this.applicationSN));
                    }
                    pTag = cTag.findTag(TAG_DISCRETIONARY_DATA, null);
                    if (cTag != null) {
                        this.discretionaryData = pTag.valueAsByteArray();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Discretionary Data = {}", (Object)ByteArrayUtils.toHex((byte[])this.discretionaryData));
                        }
                        this.siBufferSizeIndicator = this.discretionaryData[0];
                        this.siPlatform = this.discretionaryData[1];
                        this.siApplicationType = this.discretionaryData[2];
                        this.siApplicationSubtype = this.discretionaryData[3];
                        this.siSoftwareIssuer = this.discretionaryData[4];
                        this.siSoftwareVersion = this.discretionaryData[5];
                        this.siSoftwareRevision = this.discretionaryData[6];
                        this.isValidCalypsoFCI = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isValidCalypsoFCI() {
        return this.isValidCalypsoFCI;
    }

    public byte[] getDfName() {
        return this.dfName;
    }

    public byte[] getApplicationSerialNumber() {
        return this.applicationSN;
    }

    public byte getBufferSizeIndicator() {
        return this.siBufferSizeIndicator;
    }

    public int getBufferSizeValue() {
        return BUFFER_SIZE_INDICATOR_TO_BUFFER_SIZE[this.getBufferSizeIndicator()];
    }

    public byte getPlatformByte() {
        return this.siPlatform;
    }

    public byte getApplicationTypeByte() {
        return this.siApplicationType;
    }

    public boolean isRev3_2ModeAvailable() {
        return (this.siApplicationType & 8) != 0;
    }

    public boolean isRatificationCommandRequired() {
        return (this.siApplicationSubtype & 4) != 0;
    }

    public boolean hasCalypsoStoredValue() {
        return (this.siApplicationSubtype & 2) != 0;
    }

    public boolean hasCalypsoPin() {
        return (this.siApplicationSubtype & 1) != 0;
    }

    public byte getApplicationSubtypeByte() {
        return this.siApplicationSubtype;
    }

    public byte getSoftwareIssuerByte() {
        return this.siSoftwareIssuer;
    }

    public byte getSoftwareVersionByte() {
        return this.siSoftwareVersion;
    }

    public byte getSoftwareRevisionByte() {
        return this.siSoftwareRevision;
    }

    public boolean isDfInvalidated() {
        return this.isDfInvalidated;
    }

    static {
        HashMap<Integer, AbstractApduResponseParser.StatusProperties> m = new HashMap<Integer, AbstractApduResponseParser.StatusProperties>(AbstractApduResponseParser.STATUS_TABLE);
        m.put(27272, new AbstractApduResponseParser.StatusProperties(false, "Data object not found (optional mode not available)."));
        m.put(27392, new AbstractApduResponseParser.StatusProperties(false, "P1 or P2 value not supported (<>004fh, 0062h, 006Fh, 00C0h, 00D0h, 0185h and 5F52h, according to availabl optional modes)."));
        m.put(25219, new AbstractApduResponseParser.StatusProperties(true, "Successful execution, FCI request and DF is invalidated."));
        STATUS_TABLE = m;
        BUFFER_SIZE_INDICATOR_TO_BUFFER_SIZE = new int[]{0, 0, 0, 0, 0, 0, 215, 256, 304, 362, 430, 512, 608, 724, 861, 1024, 1217, 1448, 1722, 2048, 2435, 2896, 3444, 4096, 4870, 5792, 6888, 8192, 9741, 11585, 13777, 16384, 19483, 23170, 27554, 32768, 38967, 46340, 55108, 65536, 77935, 92681, 110217, 131072, 155871, 185363, 220435, 262144, 311743, 370727, 440871, 524288, 623487, 741455, 881743, 0x100000};
        TAG_FCI_TEMPLATE = new Tag(15, 1, true);
        TAG_DF_NAME = new Tag(4, 2, false);
        TAG_FCI_PROPRIETARY_TEMPLATE = new Tag(5, 2, true);
        TAG_FCI_ISSUER_DISCRETIONARY_DATA = new Tag(12, 2, true);
        TAG_APPLICATION_SERIAL_NUMBER = new Tag(7, 3, false);
        TAG_DISCRETIONARY_DATA = new Tag(19, 1, false);
    }
}

