/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser.session;

import java.util.Arrays;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.parser.session.AbstractOpenSessionRespPars;
import org.eclipse.keyple.seproxy.message.ApduResponse;

public final class OpenSession24RespPars
extends AbstractOpenSessionRespPars {
    public OpenSession24RespPars(ApduResponse response) {
        super(response, PoRevision.REV2_4);
    }

    @Override
    AbstractOpenSessionRespPars.SecureSession toSecureSession(byte[] apduResponseData) {
        return OpenSession24RespPars.createSecureSession(apduResponseData);
    }

    public static AbstractOpenSessionRespPars.SecureSession createSecureSession(byte[] apduResponseData) {
        boolean previousSessionRatified;
        byte[] data = null;
        switch (apduResponseData.length) {
            case 5: {
                previousSessionRatified = true;
                break;
            }
            case 34: {
                previousSessionRatified = true;
                data = Arrays.copyOfRange(apduResponseData, 5, 34);
                break;
            }
            case 7: {
                previousSessionRatified = false;
                break;
            }
            case 36: {
                previousSessionRatified = false;
                data = Arrays.copyOfRange(apduResponseData, 7, 36);
                break;
            }
            default: {
                throw new IllegalStateException("Bad response length to Open Secure Session: " + apduResponseData.length);
            }
        }
        byte kvc = apduResponseData[0];
        return new AbstractOpenSessionRespPars.SecureSession(Arrays.copyOfRange(apduResponseData, 1, 4), Arrays.copyOfRange(apduResponseData, 4, 5), previousSessionRatified, false, kvc, data, apduResponseData);
    }
}

