/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.parser.GetDataFciRespPars;
import org.eclipse.keyple.calypso.transaction.PoSelectionRequest;
import org.eclipse.keyple.seproxy.message.SeResponse;
import org.eclipse.keyple.transaction.MatchingSe;
import org.eclipse.keyple.transaction.SeSelectionRequest;
import org.eclipse.keyple.util.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CalypsoPo
extends MatchingSe {
    private static final Logger logger = LoggerFactory.getLogger(CalypsoPo.class);
    private final PoSelectionRequest poSelectionRequest;
    private byte[] applicationSerialNumber;
    private PoRevision revision;
    private byte[] dfName;
    private static final int PO_REV1_ATR_LENGTH = 20;
    private static final int REV1_PO_DEFAULT_WRITE_OPERATIONS_NUMBER_SUPPORTED_PER_SESSION = 3;
    private static final int REV2_PO_DEFAULT_WRITE_OPERATIONS_NUMBER_SUPPORTED_PER_SESSION = 6;
    private byte[] poAtr;
    private int modificationsCounterMax;
    private boolean modificationCounterIsInBytes = true;

    public CalypsoPo(PoSelectionRequest poSelectionRequest) {
        super((SeSelectionRequest)poSelectionRequest);
        this.poSelectionRequest = poSelectionRequest;
    }

    public void setSelectionResponse(SeResponse selectionResponse) {
        super.setSelectionResponse(selectionResponse);
        this.poSelectionRequest.updateParsersWithResponses(selectionResponse);
        if (selectionResponse.getSelectionStatus().getFci().isSuccessful()) {
            GetDataFciRespPars poFciRespPars = new GetDataFciRespPars(selectionResponse.getSelectionStatus().getFci());
            byte applicationTypeByte = poFciRespPars.getApplicationTypeByte();
            this.revision = (applicationTypeByte & 0x80) != 0 ? PoRevision.REV3_1_CLAP : (applicationTypeByte >> 3 == 5 ? PoRevision.REV3_2 : (applicationTypeByte >> 3 == 4 ? PoRevision.REV3_1 : PoRevision.REV2_4));
            this.dfName = poFciRespPars.getDfName();
            this.applicationSerialNumber = poFciRespPars.getApplicationSerialNumber();
            if (this.revision == PoRevision.REV2_4) {
                this.modificationCounterIsInBytes = false;
                this.modificationsCounterMax = 6;
            } else {
                this.modificationsCounterMax = poFciRespPars.getBufferSizeValue();
            }
        } else {
            this.poAtr = selectionResponse.getSelectionStatus().getAtr().getBytes();
            if (this.poAtr.length != 20) {
                throw new IllegalStateException("Unexpected ATR length: " + ByteArrayUtils.toHex((byte[])this.poAtr));
            }
            this.revision = PoRevision.REV1_0;
            this.dfName = null;
            this.applicationSerialNumber = new byte[8];
            this.modificationCounterIsInBytes = false;
            this.modificationsCounterMax = 3;
            System.arraycopy(this.poAtr, 12, this.applicationSerialNumber, 4, 4);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("REVISION = {}, SERIALNUMBER = {}, DFNAME = {}", new Object[]{this.revision, ByteArrayUtils.toHex((byte[])this.applicationSerialNumber), ByteArrayUtils.toHex((byte[])this.dfName)});
        }
    }

    public PoRevision getRevision() {
        return this.revision;
    }

    public byte[] getDfName() {
        return this.dfName;
    }

    public byte[] getApplicationSerialNumber() {
        return this.applicationSerialNumber;
    }

    public byte[] getAtr() {
        return this.poAtr;
    }

    public boolean isModificationsCounterInBytes() {
        return this.modificationCounterIsInBytes;
    }

    public int getModificationsCounter() {
        return this.modificationsCounterMax;
    }

    public PoClass getPoClass() {
        if (this.revision == PoRevision.REV1_0 || this.revision == PoRevision.REV2_4) {
            if (logger.isTraceEnabled()) {
                logger.trace("PO revision = {}, PO class = {}", (Object)this.revision, (Object)PoClass.LEGACY);
            }
            return PoClass.LEGACY;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("PO revision = {}, PO class = {}", (Object)this.revision, (Object)PoClass.ISO);
        }
        return PoClass.ISO;
    }

    protected final void reset() {
        super.reset();
        this.applicationSerialNumber = null;
        this.poAtr = null;
        this.dfName = null;
    }
}

