/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.command;

import org.eclipse.keyple.command.AbstractApduCommandBuilder;
import org.eclipse.keyple.command.CommandsTable;
import org.eclipse.keyple.seproxy.message.ApduRequest;

public abstract class AbstractIso7816CommandBuilder
extends AbstractApduCommandBuilder {
    public AbstractIso7816CommandBuilder(CommandsTable commandReference, ApduRequest request) {
        super(commandReference, request);
    }

    public AbstractIso7816CommandBuilder(String name, ApduRequest request) {
        super(name, request);
    }

    protected ApduRequest setApduRequest(byte cla, CommandsTable command, byte p1, byte p2, byte[] dataIn, Byte le) {
        boolean case4;
        if (dataIn != null && le != null && le != 0) {
            throw new IllegalArgumentException("Le must be equal to 0 when not null and ingoing data are present.");
        }
        int length = 4;
        if (dataIn != null) {
            length += dataIn.length + 1;
        }
        if (le != null) {
            ++length;
        }
        byte[] apdu = new byte[length];
        apdu[0] = cla;
        apdu[1] = command.getInstructionByte();
        apdu[2] = p1;
        apdu[3] = p2;
        if (dataIn != null) {
            apdu[4] = (byte)dataIn.length;
            System.arraycopy(dataIn, 0, apdu, 5, dataIn.length);
            if (le != null) {
                case4 = true;
                apdu[length - 1] = le;
            } else {
                case4 = false;
            }
        } else {
            apdu[4] = le != null ? le : (byte)0;
            case4 = false;
        }
        return new ApduRequest(command.getName(), apdu, case4);
    }
}

