/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.nativese;

import org.eclipse.keyple.plugin.remotese.exception.KeypleRemoteException;
import org.eclipse.keyple.plugin.remotese.nativese.NativeReaderService;
import org.eclipse.keyple.plugin.remotese.nativese.method.RmConnectReaderTx;
import org.eclipse.keyple.plugin.remotese.nativese.method.RmDisconnectReaderTx;
import org.eclipse.keyple.plugin.remotese.nativese.method.RmSetDefaultSelectionRequestExecutor;
import org.eclipse.keyple.plugin.remotese.nativese.method.RmTransmitExecutor;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethod;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethodTxEngine;
import org.eclipse.keyple.plugin.remotese.transport.DtoHandler;
import org.eclipse.keyple.plugin.remotese.transport.DtoSender;
import org.eclipse.keyple.plugin.remotese.transport.KeypleDtoHelper;
import org.eclipse.keyple.plugin.remotese.transport.factory.TransportNode;
import org.eclipse.keyple.plugin.remotese.transport.json.JsonParser;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.eclipse.keyple.plugin.remotese.transport.model.TransportDto;
import org.eclipse.keyple.seproxy.ReaderPlugin;
import org.eclipse.keyple.seproxy.SeProxyService;
import org.eclipse.keyple.seproxy.event.ObservableReader;
import org.eclipse.keyple.seproxy.event.ReaderEvent;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.exception.KeypleReaderNotFoundException;
import org.eclipse.keyple.seproxy.message.ProxyReader;
import org.eclipse.keyple.seproxy.plugin.AbstractObservableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeReaderServiceImpl
implements NativeReaderService,
DtoHandler,
ObservableReader.ReaderObserver {
    private static final Logger logger = LoggerFactory.getLogger(NativeReaderServiceImpl.class);
    private final DtoSender dtoSender;
    private final SeProxyService seProxyService = SeProxyService.getInstance();
    private final RemoteMethodTxEngine rmTxEngine;

    public NativeReaderServiceImpl(DtoSender dtoSender) {
        this.dtoSender = dtoSender;
        this.rmTxEngine = new RemoteMethodTxEngine(dtoSender);
    }

    public void bindDtoEndpoint(TransportNode node) {
        node.setDtoHandler(this);
    }

    @Override
    public TransportDto onDTO(TransportDto transportDto) {
        TransportDto out;
        KeypleDto keypleDTO = transportDto.getKeypleDTO();
        logger.trace("onDto {}", (Object)KeypleDtoHelper.toJson(keypleDTO));
        RemoteMethod method = RemoteMethod.get(keypleDTO.getAction());
        logger.debug("Remote Method called : {} - isRequest : {}", (Object)method, (Object)keypleDTO.isRequest());
        switch (method) {
            case READER_CONNECT: {
                if (keypleDTO.isRequest().booleanValue()) {
                    throw new IllegalStateException("a READER_CONNECT request has been received by NativeReaderService");
                }
                out = this.rmTxEngine.onDTO(transportDto);
                break;
            }
            case READER_DISCONNECT: {
                if (keypleDTO.isRequest().booleanValue()) {
                    throw new IllegalStateException("a READER_DISCONNECT request has been received by NativeReaderService");
                }
                out = this.rmTxEngine.onDTO(transportDto);
                break;
            }
            case READER_TRANSMIT: {
                if (keypleDTO.isRequest().booleanValue()) {
                    RmTransmitExecutor rmTransmit = new RmTransmitExecutor(this);
                    out = rmTransmit.execute(transportDto);
                    break;
                }
                throw new IllegalStateException("a READER_TRANSMIT response has been received by NativeReaderService");
            }
            case DEFAULT_SELECTION_REQUEST: {
                if (keypleDTO.isRequest().booleanValue()) {
                    RmSetDefaultSelectionRequestExecutor rmSetDefaultSelectionRequest = new RmSetDefaultSelectionRequestExecutor(this);
                    out = rmSetDefaultSelectionRequest.execute(transportDto);
                    break;
                }
                throw new IllegalStateException("a READER_TRANSMIT response has been received by NativeReaderService");
            }
            default: {
                logger.warn("**** ERROR - UNRECOGNIZED ****");
                logger.warn("Receive unrecognized message action : {} {} {} {}", new Object[]{keypleDTO.getAction(), keypleDTO.getSessionId(), keypleDTO.getBody(), keypleDTO.isRequest()});
                throw new IllegalStateException("a  ERROR - UNRECOGNIZED request has been received by NativeReaderService");
            }
        }
        logger.trace("onDto response to be sent {}", (Object)KeypleDtoHelper.toJson(out.getKeypleDTO()));
        return out;
    }

    @Override
    public String connectReader(ProxyReader localReader, String clientNodeId) throws KeypleReaderException {
        logger.info("connectReader {} from device {}", (Object)localReader.getName(), (Object)clientNodeId);
        RmConnectReaderTx connect = new RmConnectReaderTx(null, localReader.getName(), null, clientNodeId, localReader, clientNodeId, this);
        try {
            this.rmTxEngine.register(connect);
            return (String)connect.get();
        }
        catch (KeypleRemoteException e) {
            throw new KeypleReaderException("An error occured while calling connectReader", (Throwable)((Object)e));
        }
    }

    @Override
    public void disconnectReader(String sessionId, String nativeReaderName, String clientNodeId) throws KeypleReaderException {
        logger.info("disconnectReader {} from device {}", (Object)nativeReaderName, (Object)clientNodeId);
        RmDisconnectReaderTx disconnect = new RmDisconnectReaderTx(sessionId, nativeReaderName, clientNodeId);
        try {
            this.rmTxEngine.register(disconnect);
            Boolean status = (Boolean)disconnect.get();
            ProxyReader nativeReader = this.findLocalReader(nativeReaderName);
            if (nativeReader instanceof AbstractObservableReader) {
                ((AbstractObservableReader)nativeReader).removeObserver((ObservableReader.ReaderObserver)this);
            }
        }
        catch (KeypleRemoteException e) {
            throw new KeypleReaderException("An error occured while calling connectReader", (Throwable)((Object)e));
        }
        catch (KeypleReaderNotFoundException e) {
            e.printStackTrace();
        }
    }

    public ProxyReader findLocalReader(String nativeReaderName) throws KeypleReaderNotFoundException {
        logger.trace("Find local reader by name {} in {} plugin(s)", (Object)nativeReaderName, (Object)this.seProxyService.getPlugins().size());
        for (ReaderPlugin plugin : this.seProxyService.getPlugins()) {
            try {
                return (ProxyReader)plugin.getReader(nativeReaderName);
            }
            catch (KeypleReaderNotFoundException keypleReaderNotFoundException) {
            }
        }
        throw new KeypleReaderNotFoundException(nativeReaderName);
    }

    public void update(ReaderEvent event) {
        logger.info("NativeReaderServiceImpl listens for event from native Reader - Received Event {}", (Object)event.getEventType());
        String data = JsonParser.getGson().toJson((Object)event);
        try {
            this.dtoSender.sendDTO(new KeypleDto(RemoteMethod.READER_EVENT.getName(), data, true, null, event.getReaderName(), null, this.dtoSender.getNodeId()));
        }
        catch (KeypleRemoteException e) {
            logger.error("Event " + event.toString() + " could not be sent though Remote Service Interface", (Throwable)((Object)e));
        }
    }
}

