/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.actions.CompoundContributionItem;

public class OutlineViewHideSymbolKindMenuContributor
extends CompoundContributionItem {
    protected IContributionItem[] getContributionItems() {
        return (IContributionItem[])Arrays.stream(SymbolKind.values()).sorted(new Comparator<SymbolKind>(){

            @Override
            public int compare(SymbolKind sk1, SymbolKind sk2) {
                return sk1.name().compareTo(sk2.name());
            }
        }).map(kind -> this.createHideSymbolKindContributionItem((SymbolKind)kind)).toArray(IContributionItem[]::new);
    }

    private IContributionItem createHideSymbolKindContributionItem(SymbolKind kind) {
        return new ActionContributionItem((IAction)new HideSymbolKindAction(kind));
    }

    static boolean isHideSymbolKind(SymbolKind kind) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        return preferences.getBoolean("org.eclipse.lsp4e.outline.hide" + kind.name(), false);
    }

    static boolean toggleHideSymbolKind(SymbolKind kind) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e");
        boolean oldValue = OutlineViewHideSymbolKindMenuContributor.isHideSymbolKind(kind);
        preferences.putBoolean("org.eclipse.lsp4e.outline.hide" + kind.name(), !oldValue);
        return !oldValue;
    }

    private static class HideSymbolKindAction
    extends Action {
        private final SymbolKind kind;

        HideSymbolKindAction(SymbolKind kind) {
            super(kind.name(), 2);
            this.kind = kind;
            this.setChecked(OutlineViewHideSymbolKindMenuContributor.isHideSymbolKind(kind));
            Image img = LSPImages.imageFromSymbolKind(kind);
            if (img != null) {
                this.setImageDescriptor(ImageDescriptor.createFromImage((Image)img));
            }
        }

        public void run() {
            boolean checkedState = OutlineViewHideSymbolKindMenuContributor.toggleHideSymbolKind(this.kind);
            this.setChecked(checkedState);
        }
    }
}

