/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xml.type.internal.RegEx;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDRepeatableFacetImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDPatternFacetImpl
extends XSDRepeatableFacetImpl
implements XSDPatternFacet {
    protected EList value = null;
    protected Collection patterns;
    static /* synthetic */ Class class$0;

    public static XSDPatternFacet createPatternFacet(Node node) {
        if (XSDConstants.nodeType(node) == 30) {
            XSDPatternFacet xsdPatternFacet = XSDFactory.eINSTANCE.createXSDPatternFacet();
            xsdPatternFacet.setElement((Element)node);
            return xsdPatternFacet;
        }
        return null;
    }

    protected XSDPatternFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDPatternFacet();
    }

    public EList getValue() {
        if (this.value == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.value = new EDataTypeUniqueEList((Class)clazz, (InternalEObject)this, 11);
        }
        return this.value;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove((Object)otherEnd, msgs);
                }
                case 8: {
                    return this.basicSetAnnotation(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getLexicalValue();
            }
            case 6: {
                return this.getFacetName();
            }
            case 7: {
                return this.getEffectiveValue();
            }
            case 8: {
                return this.getAnnotation();
            }
            case 9: {
                return this.getSimpleTypeDefinition();
            }
            case 10: {
                return this.getAnnotations();
            }
            case 11: {
                return this.getValue();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setLexicalValue((String)newValue);
                return;
            }
            case 8: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 10: {
                this.getAnnotations().clear();
                this.getAnnotations().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getValue().clear();
                this.getValue().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setLexicalValue(LEXICAL_VALUE_EDEFAULT);
                return;
            }
            case 8: {
                this.setAnnotation(null);
                return;
            }
            case 10: {
                this.getAnnotations().clear();
                return;
            }
            case 11: {
                this.getValue().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 6: {
                return FACET_NAME_EDEFAULT == null ? this.getFacetName() != null : !FACET_NAME_EDEFAULT.equals(this.getFacetName());
            }
            case 7: {
                return EFFECTIVE_VALUE_EDEFAULT == null ? this.getEffectiveValue() != null : !EFFECTIVE_VALUE_EDEFAULT.equals(this.getEffectiveValue());
            }
            case 8: {
                return this.annotation != null;
            }
            case 9: {
                return this.getSimpleTypeDefinition() != null;
            }
            case 10: {
                return this.annotations != null && !this.annotations.isEmpty();
            }
            case 11: {
                return this.value != null && !this.value.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = this.createElement(30);
        this.setElement(newElement);
        return newElement;
    }

    public Collection getPatterns(boolean withDiagnostics) {
        if (this.patterns == null || withDiagnostics) {
            this.patterns = new ArrayList();
            EList theValues = this.getValue();
            if (theValues.isEmpty()) {
                XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer();
                if (xsdSimpleTypeDefinition != null && !xsdSimpleTypeDefinition.getSyntheticFacets().contains((Object)this)) {
                    this.createRequiredAttributeDiagnostic("http://www.w3.org/TR/xmlschema-1/", "element-pattern", this.getElement(), "value");
                }
            } else {
                Iterator values = theValues.iterator();
                while (values.hasNext()) {
                    String value = (String)values.next();
                    try {
                        this.patterns.add(new RegEx.RegularExpression(value, "X"));
                    }
                    catch (RegEx.ParseException parseException) {
                        if (!withDiagnostics) continue;
                        this.createPatternDiagnostic(parseException.getMessage(), parseException.getLocation());
                    }
                }
            }
        }
        return this.patterns;
    }

    public void validateValue() {
        this.getPatterns(true);
    }

    protected XSDDiagnostic createPatternDiagnostic(String parseError, int location) {
        XSDDiagnostic result = this.getXSDFactory().createXSDDiagnostic();
        result.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
        result.setMessage(XSDPlugin.INSTANCE.getString("_UI_XSDError_message", new Object[]{XSDPlugin.INSTANCE.getString("dt-regex", new Object[]{this.getLexicalValue(), new Integer(location), parseError})}));
        result.setAnnotationURI("http://www.w3.org/TR/xmlschema-1/#dt-regex");
        result.setPrimaryComponent(this);
        result.setNode(this.getElement());
        this.getDiagnostics().add((Object)result);
        return result;
    }

    protected boolean analyze() {
        super.analyze();
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer();
        if (xsdSimpleTypeDefinition != null && !xsdSimpleTypeDefinition.getSyntheticFacets().contains((Object)this)) {
            String newValue = this.getLexicalValue();
            if (!this.getValue().contains((Object)newValue)) {
                this.getValue().clear();
                if (newValue != null) {
                    this.getValue().add((Object)newValue);
                }
                this.patterns = null;
            }
        }
        return true;
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (eAttribute == XSDPackage.eINSTANCE.getXSDFacet_LexicalValue()) {
            this.traverseToRootForAnalysis();
            this.patterns = null;
        }
    }

    public boolean isConstraintSatisfied(Object value) {
        Iterator thePatterns = this.getPatterns(false).iterator();
        while (thePatterns.hasNext()) {
            RegEx.RegularExpression pattern = (RegEx.RegularExpression)thePatterns.next();
            if (pattern.matches((String)value)) continue;
            return false;
        }
        return true;
    }

    public Object getEffectiveValue() {
        return this.getValue();
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDPatternFacetImpl clonedPatternFacet = (XSDPatternFacetImpl)this.getXSDFactory().createXSDPatternFacet();
        clonedPatternFacet.isReconciling = true;
        if (this.getLexicalValue() != null) {
            clonedPatternFacet.setLexicalValue(this.getLexicalValue());
        }
        if (shareDOM && this.getElement() != null) {
            clonedPatternFacet.setElement(this.getElement());
        }
        if (deep && this.getAnnotation() != null) {
            clonedPatternFacet.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        clonedPatternFacet.isReconciling = shareDOM;
        return clonedPatternFacet;
    }
}

