/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDXPathDefinition;
import org.eclipse.xsd.XSDXPathVariety;
import org.eclipse.xsd.impl.XSDComponentImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDXPathDefinitionImpl
extends XSDComponentImpl
implements XSDXPathDefinition {
    protected static final XSDXPathVariety VARIETY_EDEFAULT = XSDXPathVariety.SELECTOR_LITERAL;
    protected XSDXPathVariety variety = VARIETY_EDEFAULT;
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    protected XSDAnnotation annotation = null;

    public static XSDXPathDefinition createXPathDefinition(Node node) {
        switch (XSDConstants.nodeType(node)) {
            case 14: 
            case 34: {
                XSDXPathDefinition xsdXPathDefinition = XSDFactory.eINSTANCE.createXSDXPathDefinition();
                xsdXPathDefinition.setElement((Element)node);
                return xsdXPathDefinition;
            }
        }
        return null;
    }

    protected XSDXPathDefinitionImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDXPathDefinition();
    }

    public XSDXPathVariety getVariety() {
        return this.variety;
    }

    public void setVariety(XSDXPathVariety newVariety) {
        XSDXPathVariety oldVariety = this.variety;
        XSDXPathVariety xSDXPathVariety = this.variety = newVariety == null ? VARIETY_EDEFAULT : newVariety;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldVariety, (Object)this.variety));
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldValue, (Object)this.value));
        }
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)this.annotation).eInverseRemove((InternalEObject)this, -8, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)newAnnotation).eInverseAdd((InternalEObject)this, -8, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove((Object)otherEnd, msgs);
                }
                case 7: {
                    return this.basicSetAnnotation(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getVariety();
            }
            case 6: {
                return this.getValue();
            }
            case 7: {
                return this.getAnnotation();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setVariety((XSDXPathVariety)((Object)newValue));
                return;
            }
            case 6: {
                this.setValue((String)newValue);
                return;
            }
            case 7: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setVariety(VARIETY_EDEFAULT);
                return;
            }
            case 6: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 7: {
                this.setAnnotation(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return this.variety != VARIETY_EDEFAULT;
            }
            case 6: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 7: {
                return this.annotation != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (variety: ");
        result.append((Object)this.variety);
        result.append(", value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = this.createElement(XSDXPathVariety.SELECTOR_LITERAL == this.getVariety() ? 34 : 14);
        if (newElement != null) {
            newElement.setAttributeNS(null, "xpath", this.getValue());
            this.setElement(newElement);
        }
        return newElement;
    }

    public void validate() {
        super.validate();
        String anchor = null;
        String elementName = null;
        switch (this.getVariety().getValue()) {
            case 1: {
                anchor = "element-field";
                elementName = "field";
                break;
            }
            case 0: {
                anchor = "element-selector";
                elementName = "selector";
            }
        }
        Element theElement = this.getElement();
        if (theElement != null) {
            this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", anchor, theElement, new String[]{"id", "xpath"});
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "id", false);
            this.checkComplexContent("annotated", "http://www.w3.org/TR/xmlschema-1/", anchor, theElement);
        }
        this.checkAttributeTypeConstraint((XSDComplexTypeDefinition)this.getSchema().getSchemaForSchema().resolveElementDeclaration(elementName).getTypeDefinition(), "xpath", this.getValue(), "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "xpath", true);
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement == this.getElement()) {
            XSDXPathVariety newVariety = XSDXPathVariety.get(changedElement.getLocalName());
            if (newVariety != this.getVariety()) {
                this.setVariety(newVariety);
            }
            if (changedElement.hasAttributeNS(null, "xpath")) {
                String newValue = changedElement.getAttributeNS(null, "xpath");
                if (newValue == null || !newValue.equals(this.getValue())) {
                    this.setValue(newValue);
                }
            } else if (this.getValue() != null) {
                this.setValue(null);
            }
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        Element theElement = this.getElement();
        if (!(eAttribute != null && eAttribute != XSDPackage.eINSTANCE.getXSDXPathDefinition_Variety() || theElement == null || eAttribute == null || this.isReconciling)) {
            Element newElement = this.createElement(XSDXPathVariety.SELECTOR_LITERAL == this.getVariety() ? 34 : 14);
            this.forceReplace(newElement, theElement);
            this.setElement(newElement);
        }
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDXPathDefinitionImpl clonedXPathDefinition = (XSDXPathDefinitionImpl)this.getXSDFactory().createXSDXPathDefinition();
        clonedXPathDefinition.isReconciling = true;
        clonedXPathDefinition.setVariety(this.getVariety());
        clonedXPathDefinition.setValue(this.getValue());
        if (deep && this.getAnnotation() != null) {
            clonedXPathDefinition.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedXPathDefinition.setElement(this.getElement());
        }
        clonedXPathDefinition.isReconciling = shareDOM;
        return clonedXPathDefinition;
    }
}

