/*******************************************************************************
 * Copyright (c) 2008 - 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class GenFeatureItemProvider extends JavaElementItemProviderAdapter
		implements IItemJavaElementSource {

	protected static final List<EReference> GROUP_REFERENCES = Arrays
			.asList(GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES = Arrays
			.asList();

	public GenFeatureItemProvider(
			GenModelJavaElementSourceContributor sourceContributor) {
		super(sourceContributor);
	}

	@Override
	public List<IItemJavaElementDescriptor> getJavaElementDescriptors(
			Object object) {
		GenFeature genFeature = (GenFeature) object;
		if (!isFullyResolved(genFeature))
			return Collections.emptyList();

		UniqueEList<IItemJavaElementDescriptor> list = new UniqueEList<IItemJavaElementDescriptor>();

		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		GenModel genModel = genFeature.getGenModel();
		String modelDir = genModel.getModelDirectory();

		if (genFeature.isGet()) {
			if (!genFeature.isSuppressedGetVisibility())
				addMethod(
						modelDir,
						genFeature.getGenClass().getQualifiedInterfaceName(),
						genFeature.getGetAccessor(),
						CAT_INTERFACE,
						Messages.GenFeatureItemProvider_GetInterfaceLabel,
						Messages.GenFeatureItemProvider_GetInterfaceDescription,
						GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE,
						true, list);

			if (!genFeature.getGenClass().isDynamic())
				addMethod(
						modelDir,
						genFeature.getGenClass().getQualifiedClassName(),
						genFeature.getGetAccessor(),
						CAT_IMPLEMENTATION,
						Messages.GenFeatureItemProvider_GetImplementationLabel,
						Messages.GenFeatureItemProvider_GetImplementationDescription,
						GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE,
						true, list);
		}

		if (genFeature.isSet()) {
			if (!genFeature.isSuppressedSetVisibility())
				addMethod(
						modelDir,
						genFeature.getGenClass().getQualifiedInterfaceName(),
						"set" //$NON-NLS-1$
								+ genFeature.getAccessorName(),
						genFeature.getType(null),
						CAT_INTERFACE,
						Messages.GenFeatureItemProvider_SetInterfaceLabel,
						Messages.GenFeatureItemProvider_SetInterfaceDescription,
						GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE,
						true, list);

			if (!genFeature.getGenClass().isDynamic())
				addMethod(
						modelDir,
						genFeature.getGenClass().getQualifiedClassName(),
						"set" //$NON-NLS-1$
								+ genFeature.getAccessorName(),
						genFeature.getType(null),
						CAT_IMPLEMENTATION,
						Messages.GenFeatureItemProvider_SetImplementationLabel,
						Messages.GenFeatureItemProvider_SetImplementationDescription,
						GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE,
						true, list);
		}

		if (genFeature.isIsSet()) {
			if (!genFeature.isSuppressedIsSetVisibility())
				addMethod(
						modelDir,
						genFeature.getGenClass().getQualifiedInterfaceName(),
						"isSet" //$NON-NLS-1$
								+ genFeature.getAccessorName(),
						CAT_INTERFACE,
						Messages.GenFeatureItemProvider_IsSetInterfaceLabel,
						Messages.GenFeatureItemProvider_IsSetInterfaceDescription,
						GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE,
						true, list);

			if (!genFeature.getGenClass().isDynamic())
				addMethod(
						modelDir,
						genFeature.getGenClass().getQualifiedClassName(),
						"isSet" //$NON-NLS-1$
								+ genFeature.getAccessorName(),
						CAT_IMPLEMENTATION,
						Messages.GenFeatureItemProvider_IsSetImplementationLabel,
						Messages.GenFeatureItemProvider_IsSetImplementationDescription,
						GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE,
						true, list);
		}

		if (genFeature.isUnset()) {
			if (!genFeature.isSuppressedUnsetVisibility())
				addMethod(
						modelDir,
						genFeature.getGenClass().getQualifiedInterfaceName(),
						"unset" //$NON-NLS-1$
								+ genFeature.getAccessorName(),
						CAT_INTERFACE,
						Messages.GenFeatureItemProvider_UnsetInterfaceLabel,
						Messages.GenFeatureItemProvider_UnsetInterfaceDescription,
						GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE,
						true, list);

			if (!genFeature.getGenClass().isDynamic())
				addMethod(
						modelDir,
						genFeature.getGenClass().getQualifiedClassName(),
						"unset" //$NON-NLS-1$
								+ genFeature.getAccessorName(),
						CAT_IMPLEMENTATION,
						Messages.GenFeatureItemProvider_UnsetImplementationLabel,
						Messages.GenFeatureItemProvider_UnsetImplementationDescription,
						GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE,
						true, list);
		}

		// TODO add other methods (basicGet/Set/Unset)

		IPath path = new Path(genModel.getModelProjectDirectory());
		IJavaProject ctx = JavaCore.create(root.getProject(path.segment(0)));

		if (!genFeature.isPrimitiveType()) {
			String type = genFeature.getType(null);
			// TODO there has to be a better way...
			if (genFeature.getEcoreFeature().isMany())
				type = genFeature.getQualifiedListItemType(null);
			
			addType(ctx, type, CAT_INTERFACE,
					Messages.GenFeatureItemProvider_FeatureTypeLabel,
					Messages.GenFeatureItemProvider_FeatureTypeDescription,
					null, list);
		}

		// TODO add list, map entry types

		return list;
	}

	@Override
	protected GroupReferenceGenModelSwitch createGroupReferenceGenModelSwitch() {
		return new GroupReferenceGenModelSwitch() {
			@Override
			public List<EReference> caseGenFeature(GenFeature object) {
				return GROUP_REFERENCES;
			}
		};
	}

	@Override
	protected ObservedFeatureGenModelSwitch createObservedFeatureGenModelSwitch() {
		return new ObservedFeatureGenModelSwitch() {
			@Override
			public List<EStructuralFeature> caseGenFeature(GenFeature object) {
				return OBSERVED_FEATURES;
			}
		};
	}
}
