/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.prov.client.protocol;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.net4j.core.impl.AbstractRequestWithConfirmation;
import org.eclipse.net4j.examples.prov.Feature;
import org.eclipse.net4j.examples.prov.ProvFactory;
import org.eclipse.net4j.util.IOHelper;

public class UploadArchiveRequest
extends AbstractRequestWithConfirmation {
    private String fileName;

    public UploadArchiveRequest(String fileName) {
        this.fileName = fileName;
    }

    public short getSignalId() {
        return 4;
    }

    public void request() {
        FileInputStream is = null;
        try {
            try {
                int read;
                File file = new File(this.fileName);
                this.transmitString(file.getName());
                long size = file.length();
                this.transmitLong(size);
                is = new FileInputStream(file);
                byte[] buffer = new byte[4096];
                while ((read = ((InputStream)is).read(buffer)) != -1) {
                    int i = 0;
                    while (i < read) {
                        this.transmitByte(buffer[i]);
                        ++i;
                    }
                }
            }
            catch (FileNotFoundException ex) {
                this.error("Archive not found: " + this.fileName, ex);
            }
            catch (IOException ex) {
                this.error("Error while reading archive: " + this.fileName, ex);
            }
        }
        finally {
            IOHelper.close(is);
        }
    }

    public Object confirm() {
        int count = this.receiveInt();
        if (count == -1) {
            return null;
        }
        Feature[] features = new Feature[count];
        int i = 0;
        while (i < count) {
            String id = this.receiveString();
            String version = this.receiveString();
            features[i] = ProvFactory.eINSTANCE.createFeature();
            features[i].setId(id);
            features[i].setVersion(version);
            ++i;
        }
        return features;
    }
}

