/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.examples.owl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.eodm.owl.OWLClass;
import org.eclipse.eodm.owl.OWLOntology;
import org.eclipse.eodm.owl.Property;
import org.eclipse.eodm.owl.reasoner.OWLTaxonomyReasoner;
import org.eclipse.eodm.owl.reasoner.structural.StructuralReasonerFactory;
import org.eclipse.eodm.owl.resource.parser.OWLDocument;
import org.eclipse.eodm.owl.resource.parser.impl.OWLDocumentImpl;
import org.eclipse.eodm.owl.resource.parser.impl.OWLParserImpl;

public class OWLReasonerExample {
    private OWLOntology ontology = null;

    static {
        System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
    }

    public static void main(String[] args) {
        OWLReasonerExample testSuite = new OWLReasonerExample();
        String file = "./testcase/univ-bench-dl.owl";
        testSuite.loadOntology(file);
        testSuite.testStructuralReasoner();
    }

    public void testStructuralReasoner() {
        OWLTaxonomyReasoner reasoner = StructuralReasonerFactory.instance().createOWLTaxonmyReasoner();
        reasoner.initialize(this.ontology);
        this.runTest(reasoner);
    }

    public void runTest(OWLTaxonomyReasoner reasoner) {
        System.out.println("Test getDescendantClasses...");
        OWLClass c1 = (OWLClass)this.ontology.getContainedResource(null, "Person");
        List l = reasoner.getDescendantClasses(c1);
        System.out.println("There are " + l.size() + " sub classes of " + c1.getURI());
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            OWLClass clazz = (OWLClass)iter.next();
            System.out.println(clazz.getURI());
        }
        System.out.println("\nTest isDescendantClassOf...");
        OWLClass c2 = (OWLClass)this.ontology.getContainedResource(null, "Employee");
        if (reasoner.isSubClassOf(c1, c2)) {
            System.out.println(String.valueOf(c1.getURI()) + " is subClassOf " + c2.getURI());
        } else {
            System.out.println(String.valueOf(c1.getURI()) + " is not subClassOf " + c2.getURI());
        }
        System.out.println("\nTest getDescendantProperties...");
        Property p1 = (Property)this.ontology.getContainedResource(null, "isMemberOf");
        l = reasoner.getDescendantProperties(p1);
        System.out.println("There are " + l.size() + " sub properties of " + p1.getURI());
        Iterator iter2 = l.iterator();
        while (iter2.hasNext()) {
            Property p = (Property)iter2.next();
            System.out.println(p.getURI());
        }
        System.out.println("\nTest isDescendantPropertyOf...");
        Property p2 = (Property)this.ontology.getContainedResource(null, "enrollIn");
        if (reasoner.isSubPropertyOf(p1, p2)) {
            System.out.println(String.valueOf(p1.getURI()) + " is sub property of " + p2.getURI());
        } else {
            System.out.println(String.valueOf(p1.getURI()) + " is not sub property of " + p2.getURI());
        }
    }

    public void loadOntology(String file) {
        OWLParserImpl parser = new OWLParserImpl();
        OWLDocumentImpl wine = new OWLDocumentImpl(file, null, true);
        parser.addOWLDocument((OWLDocument)wine);
        this.ontology = parser.parseOWLDocument((OWLDocument)wine);
    }
}

