/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: RDFBlankNode.java,v 1.2 2007/03/18 08:39:02 lzhang Exp $
 */

package org.eclipse.eodm.rdf.resource.parser.element;

import java.util.Random;

import org.eclipse.eodm.vocabulary.RDFS;

/**
 * The class of RDF blank node.
 */
public class RDFBlankNode implements RDFResourceElement {

    private String id;

    private static String prefix;

    private static int index;

    static {
        // the prefix of annoymous blank node id
        long randomResult = new Random().nextLong();
        prefix = "_" + Long.toHexString(randomResult) + "-";

        // the index of annonymous blank node id
        index = 0;
    }

    /**
     * Construct a blank node. The id will be set to the last ID plus one
     */
    public RDFBlankNode() {
        id = nextID();
    }

    /**
     * Construct a blank node with designated ID. eg. nodeID = "abc" in rdf
     * document
     * 
     * @param id
     *            the designated ID
     */
    public RDFBlankNode(String id) {
        if (id == null)
            throw new IllegalArgumentException("id must NOT be null");
        this.id = id;
    }

    /**
     * Get the blank node ID
     * 
     * @return blank node ID
     */
    public String getID() {
        return id;
    }

    private String nextID() {
        // increment by 1
        index++;

        // the annoymous blank node id
        return prefix + index;
    }

    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (!(o instanceof RDFBlankNode))
            return false;

        final RDFBlankNode blankNode = (RDFBlankNode) o;

        return id.equals(blankNode.getID());
    }

    public int hashCode() {
        return id.hashCode();
    }

    public String toString() {
        return "BlankNode{" + "id='" + id + "'" + "}";
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.rdfs.resource.parser.element.RDFResourceElement#getNamespace()
     */
    public String getNamespace() {
        return RDFS.BNODE_NAMESPACE;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.rdfs.resource.parser.element.RDFResourceElement#getLocalName()
     */
    public String getLocalName() {
        return id;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.rdfs.resource.parser.element.RDFResourceElement#getFullURI()
     */
    public String getFullURI() {
        return getNamespace() + id;
    }
}