/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: NamespaceImpl.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfweb.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.rdf.rdfweb.util.RDFWebPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Namespace</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfweb.impl.NamespaceImpl#getNamespaceURIRef <em>Namespace URI Ref</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class NamespaceImpl extends EObjectImpl implements Namespace {
	/**
	 * The cached value of the '{@link #getNamespaceURIRef() <em>Namespace URI Ref</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNamespaceURIRef()
	 * @generated
	 * @ordered
	 */
	protected URIReference namespaceURIRef = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NamespaceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RDFWebPackage.eINSTANCE.getNamespace();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public URIReference getNamespaceURIRef() {
		if (namespaceURIRef != null && namespaceURIRef.eIsProxy()) {
			URIReference oldNamespaceURIRef = namespaceURIRef;
			namespaceURIRef = (URIReference)eResolveProxy((InternalEObject)namespaceURIRef);
			if (namespaceURIRef != oldNamespaceURIRef) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RDFWebPackage.NAMESPACE__NAMESPACE_URI_REF, oldNamespaceURIRef, namespaceURIRef));
			}
		}
		return namespaceURIRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public URIReference basicGetNamespaceURIRef() {
		return namespaceURIRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNamespaceURIRef(URIReference newNamespaceURIRef) {
		URIReference oldNamespaceURIRef = namespaceURIRef ;
		namespaceURIRef = newNamespaceURIRef ;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RDFWebPackage.NAMESPACE__NAMESPACE_URI_REF, oldNamespaceURIRef, newNamespaceURIRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFWebPackage.NAMESPACE__NAMESPACE_URI_REF:
				if (resolve) return getNamespaceURIRef();
				return basicGetNamespaceURIRef();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFWebPackage.NAMESPACE__NAMESPACE_URI_REF:
				setNamespaceURIRef((URIReference)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFWebPackage.NAMESPACE__NAMESPACE_URI_REF:
				setNamespaceURIRef((URIReference)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RDFWebPackage.NAMESPACE__NAMESPACE_URI_REF:
				return namespaceURIRef != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //NamespaceImpl
