/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.impl;

import java.io.File;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.GitProvider;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.RepositoryPredicate;
import org.eclipse.oomph.predicates.impl.PredicateImpl;
import org.eclipse.team.core.RepositoryProvider;

public class RepositoryPredicateImpl
extends PredicateImpl
implements RepositoryPredicate {
    protected static final IProject PROJECT_EDEFAULT = null;
    protected IProject project = PROJECT_EDEFAULT;

    protected RepositoryPredicateImpl() {
    }

    protected EClass eStaticClass() {
        return PredicatesPackage.Literals.REPOSITORY_PREDICATE;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject newProject) {
        IProject oldProject = this.project;
        this.project = newProject;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldProject, (Object)this.project));
        }
    }

    private String getGitDirAbsolutePath(IProject project) {
        if (project != null) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider == null) {
                java.net.URI locationURI = project.getLocationURI();
                if (locationURI != null && "file".equals(locationURI.getScheme())) {
                    URI emfURI = URI.createURI((String)locationURI.toString());
                    File parent = new File(emfURI.toFileString()).getParentFile();
                    while (parent != null && parent.isDirectory()) {
                        File gitFolder = new File(parent, ".git");
                        if (new File(gitFolder, "index").exists()) {
                            return gitFolder.toString();
                        }
                        parent = parent.getParentFile();
                    }
                }
            } else {
                try {
                    if (provider instanceof GitProvider) {
                        GitProvider gitProvider = (GitProvider)provider;
                        GitProjectData data = gitProvider.getData();
                        RepositoryMapping repositoryMapping = data.getRepositoryMapping((IResource)project);
                        IPath gitDirAbsolutePath = repositoryMapping.getGitDirAbsolutePath();
                        return gitDirAbsolutePath == null ? null : gitDirAbsolutePath.toOSString();
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
                try {
                    Class<?> providerClass = provider.getClass();
                    Method getSVNWorkspaceRootMethod = providerClass.getMethod("getSVNWorkspaceRoot", new Class[0]);
                    Object svnWorkspaceRoot = getSVNWorkspaceRootMethod.invoke((Object)provider, new Object[0]);
                    Class<?> workspaceRootClass = svnWorkspaceRoot.getClass();
                    Method getRepositoryMethod = workspaceRootClass.getMethod("getRepository", new Class[0]);
                    Object repositoryLocation = getRepositoryMethod.invoke(svnWorkspaceRoot, new Object[0]);
                    Class<?> repositoryLocationClass = repositoryLocation.getClass();
                    Method getLocationMethod = repositoryLocationClass.getMethod("getLocation", new Class[0]);
                    Object location = getLocationMethod.invoke(repositoryLocation, new Object[0]);
                    return location == null ? null : location.toString();
                }
                catch (Throwable throwable) {
                    try {
                        Class<?> providerClass = provider.getClass();
                        Method getRepositoryLocationMethod = providerClass.getMethod("getRepositoryLocation", new Class[0]);
                        Object repositoryLocation = getRepositoryLocationMethod.invoke((Object)provider, new Object[0]);
                        Class<?> repositoryLocationClass = repositoryLocation.getClass();
                        Method getRepositoryRootUrlMethod = repositoryLocationClass.getMethod("getRepositoryRootUrl", new Class[0]);
                        Object respositoryRootURL = getRepositoryRootUrlMethod.invoke(repositoryLocation, new Object[0]);
                        return respositoryRootURL == null ? null : respositoryRootURL.toString();
                    }
                    catch (Throwable throwable2) {
                        return "Unknown repo";
                    }
                }
            }
        }
        return null;
    }

    public boolean matches(IResource resource) {
        String prototypeGitDirAbsolutePath = this.getGitDirAbsolutePath(this.getProject());
        String gitDirAbsolutePath = this.getGitDirAbsolutePath(resource.getProject());
        return prototypeGitDirAbsolutePath == null ? gitDirAbsolutePath == null : prototypeGitDirAbsolutePath.equals(gitDirAbsolutePath);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getProject();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setProject((IProject)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setProject(PROJECT_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return PROJECT_EDEFAULT == null ? this.project != null : !PROJECT_EDEFAULT.equals((Object)this.project);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (project: ");
        result.append(this.project);
        result.append(')');
        return result.toString();
    }
}

