/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties;

import java.util.HashSet;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.views.properties.PropertiesMessages;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PinPropertySheetAction;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertyShowInContext;

public class PropertySheet
extends PageBookView
implements ISelectionListener,
IShowInTarget,
IShowInSource,
IRegistryEventListener {
    public static final String HELP_CONTEXT_PROPERTY_SHEET_VIEW = "org.eclipse.ui.property_sheet_view_context";
    private static final String EXT_POINT = "org.eclipse.ui.propertiesView";
    private ISelection bootstrapSelection;
    private ISelection currentSelection;
    private IWorkbenchPart currentPart;
    private IAction pinPropertySheetAction = new PinPropertySheetAction();
    private HashSet ignoredViews;
    private boolean wasHidden;

    public PropertySheet() {
        RegistryFactory.getRegistry().addListener((IRegistryEventListener)this, EXT_POINT);
    }

    protected IPage createDefaultPage(PageBook book) {
        Object page = (IPageBookViewPage)Adapters.adapt((Object)((Object)this), IPropertySheetPage.class);
        if (page == null) {
            page = new PropertySheetPage();
        }
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        return page;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.pinPropertySheetAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("checked".equals(event.getProperty())) {
                    PropertySheet.this.updateContentDescription();
                }
            }
        });
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add(this.pinPropertySheetAction);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add(this.pinPropertySheetAction);
        this.getSite().getPage().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((Control)this.getPageBook(), HELP_CONTEXT_PROPERTY_SHEET_VIEW);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        RegistryFactory.getRegistry().removeListener((IRegistryEventListener)this);
        this.currentPart = null;
        this.currentSelection = null;
        this.pinPropertySheetAction = null;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (part instanceof PropertySheet) {
            return null;
        }
        IPropertySheetPage page = (IPropertySheetPage)Adapters.adapt((Object)part, IPropertySheetPage.class);
        if (page != null) {
            if (page instanceof IPageBookViewPage) {
                this.initPage((IPageBookViewPage)page);
            }
            page.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(part, (IPage)page);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec rec) {
        IPropertySheetPage page = (IPropertySheetPage)rec.page;
        page.dispose();
        rec.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IViewReference[] viewrefs;
        ISelection selection;
        IWorkbenchPage page = this.getSite().getPage();
        if (page == null) {
            return null;
        }
        ISelection originalSel = page.getSelection();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart != null && activePart != this) {
            this.bootstrapSelection = originalSel;
            return activePart;
        }
        if (originalSel == null || originalSel.isEmpty()) {
            return null;
        }
        IEditorPart activeEditor = page.getActiveEditor();
        if (activeEditor != null && this.isImportant((IWorkbenchPart)activeEditor) && activeEditor.getSite().getSelectionProvider() != null && originalSel.equals(selection = activeEditor.getSite().getSelectionProvider().getSelection())) {
            this.bootstrapSelection = originalSel;
            return activeEditor;
        }
        IViewReference[] iViewReferenceArray = viewrefs = page.getViewReferences();
        int n = viewrefs.length;
        int n2 = 0;
        while (n2 < n) {
            ISelection selection2;
            IViewReference ref = iViewReferenceArray[n2];
            IWorkbenchPart part = ref.getPart(false);
            if (part != null && part != this && page.isPartVisible(part) && this.isImportant(part) && part.getSite().getSelectionProvider() != null && originalSel.equals(selection2 = part.getSite().getSelectionProvider().getSelection())) {
                this.bootstrapSelection = originalSel;
                return part;
            }
            ++n2;
        }
        return null;
    }

    public void init(IViewSite site) throws PartInitException {
        site.getPage().addPostSelectionListener((ISelectionListener)this);
        super.init(site);
    }

    public void saveState(IMemento memento) {
        String secondaryId = this.getViewSite().getSecondaryId();
        if (secondaryId == null) {
            super.saveState(memento);
        } else {
            this.getViewSite().getPage().hideView((IViewPart)this);
        }
    }

    protected boolean isImportant(IWorkbenchPart part) {
        String partID = part.getSite().getId();
        boolean isPropertyView = this.getSite().getId().equals(partID);
        return !this.isPinned() && !isPropertyView && !this.isViewIgnored(partID);
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.currentPart)) {
            if (this.isPinned()) {
                this.pinPropertySheetAction.setChecked(false);
            }
            this.currentPart = null;
        }
        super.partClosed(part);
    }

    protected void partVisible(IWorkbenchPart part) {
        super.partVisible(part);
    }

    protected void partHidden(IWorkbenchPart part) {
        if (part == this) {
            this.wasHidden = true;
        }
    }

    public void partActivated(IWorkbenchPart part) {
        IWorkbenchPartSite site;
        IWorkbenchPage page;
        IViewPart[] stack;
        if (this.wasHidden && part == this) {
            this.wasHidden = false;
            super.partActivated(part);
            if (this.currentPart != null) {
                IPropertySheetPage page2 = (IPropertySheetPage)this.getCurrentPage();
                if (page2 != null) {
                    page2.selectionChanged(this.currentPart, this.currentSelection);
                }
                this.updateContentDescription();
            }
            return;
        }
        if (this.wasHidden && (stack = (page = (site = this.getSite()).getPage()).getViewStack((IViewPart)this)) != null) {
            IViewPart[] iViewPartArray = stack;
            int n = stack.length;
            int n2 = 0;
            while (n2 < n) {
                IViewPart vPart = iViewPartArray[n2];
                if (vPart == part) {
                    return;
                }
                ++n2;
            }
        }
        IContributedContentsView view = (IContributedContentsView)Adapters.adapt((Object)part, IContributedContentsView.class);
        IWorkbenchPart source = null;
        if (view != null) {
            source = view.getContributingPart();
        }
        if (source != null) {
            super.partActivated(source);
        } else {
            super.partActivated(part);
        }
        if (this.isImportant(part)) {
            this.currentPart = part;
            this.currentSelection = null;
        }
        if (this.bootstrapSelection != null) {
            IPropertySheetPage page3 = (IPropertySheetPage)this.getCurrentPage();
            if (page3 != null) {
                page3.selectionChanged(part, this.bootstrapSelection);
            }
            this.bootstrapSelection = null;
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        boolean visible;
        if (part == null || !part.equals(this.currentPart)) {
            return;
        }
        if (sel == null || !this.isImportant(part) || sel.equals(this.currentSelection)) {
            return;
        }
        this.currentPart = part;
        this.currentSelection = sel;
        boolean bl = visible = this.getSite() != null && this.getSite().getPage().isPartVisible((IWorkbenchPart)this);
        if (!visible) {
            return;
        }
        IPropertySheetPage page = (IPropertySheetPage)this.getCurrentPage();
        if (page != null) {
            page.selectionChanged(this.currentPart, this.currentSelection);
        }
        this.updateContentDescription();
    }

    private void updateContentDescription() {
        if (this.isPinned() && this.currentPart != null) {
            this.setContentDescription(NLS.bind((String)PropertiesMessages.Selection_description, (Object)this.currentPart.getTitle()));
        } else {
            this.setContentDescription("");
        }
    }

    protected Object getViewAdapter(Class key) {
        if (ISaveablePart.class.equals((Object)key)) {
            return this.getSaveablePart();
        }
        return super.getViewAdapter(key);
    }

    protected ISaveablePart getSaveablePart() {
        IWorkbenchPart part = this.getCurrentContributingPart();
        if (part instanceof ISaveablePart) {
            return (ISaveablePart)part;
        }
        return null;
    }

    public boolean isPinned() {
        return this.pinPropertySheetAction != null && this.pinPropertySheetAction.isChecked();
    }

    public ShowInContext getShowInContext() {
        return new PropertyShowInContext(this.currentPart, this.currentSelection);
    }

    public boolean show(ShowInContext aContext) {
        if (!this.isPinned() && aContext instanceof PropertyShowInContext) {
            PropertyShowInContext context = (PropertyShowInContext)aContext;
            this.partActivated(context.getPart());
            this.selectionChanged(context.getPart(), context.getSelection());
            return true;
        }
        return false;
    }

    public void setPinned(boolean pinned) {
        this.pinPropertySheetAction.setChecked(pinned);
        this.updateContentDescription();
    }

    private HashSet getIgnoredViews() {
        if (this.ignoredViews == null) {
            this.ignoredViews = new HashSet();
            IExtensionRegistry registry = RegistryFactory.getRegistry();
            IExtensionPoint ep = registry.getExtensionPoint(EXT_POINT);
            if (ep != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = ep.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] elements;
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String id;
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if ("excludeSources".equalsIgnoreCase(element.getName()) && (id = element.getAttribute("id")) != null) {
                            this.ignoredViews.add(id);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return this.ignoredViews;
    }

    private boolean isViewIgnored(String partID) {
        return this.getIgnoredViews().contains(partID);
    }

    public void added(IExtension[] extensions) {
        this.ignoredViews = null;
    }

    public void added(IExtensionPoint[] extensionPoints) {
        this.ignoredViews = null;
    }

    public void removed(IExtension[] extensions) {
        this.ignoredViews = null;
    }

    public void removed(IExtensionPoint[] extensionPoints) {
        this.ignoredViews = null;
    }
}

