/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server;

import java.util.Iterator;
import javax.naming.Context;
import javax.naming.NamingException;
import org.eclipse.net4j.internal.jms.DestinationImpl;
import org.eclipse.net4j.internal.jms.MessageImpl;
import org.eclipse.net4j.internal.jms.QueueImpl;
import org.eclipse.net4j.internal.jms.TopicImpl;
import org.eclipse.net4j.jms.internal.server.Server;
import org.eclipse.net4j.jms.internal.server.ServerConsumer;
import org.eclipse.net4j.jms.server.IDestination;
import org.eclipse.net4j.jms.server.IStore;
import org.eclipse.net4j.jms.server.IStoreTransaction;
import org.eclipse.net4j.util.concurrent.RoundRobinList;

public class ServerDestination
implements IDestination {
    private String name;
    private IDestination.Type type;
    private RoundRobinList<ServerConsumer> consumers = new RoundRobinList();

    public ServerDestination(String name, IDestination.Type type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public IDestination.Type getType() {
        return this.type;
    }

    public DestinationImpl bind(Context context, boolean rebind) throws NamingException {
        QueueImpl destination;
        Object object = destination = this.type == IDestination.Type.QUEUE ? new QueueImpl(this.name) : new TopicImpl(this.name);
        if (rebind) {
            context.rebind(this.name, (Object)destination);
        } else {
            context.bind(this.name, (Object)destination);
        }
        return destination;
    }

    public boolean addConsumer(ServerConsumer consumer) {
        if (consumer.isDurable()) {
            IStore store = Server.INSTANCE.getStore();
            IStoreTransaction transaction = store.startTransaction();
            transaction.consumerAdded(consumer);
            store.commitTransaction(transaction);
        }
        return this.consumers.add((Object)consumer);
    }

    public boolean removeConsumer(final long consumerID) {
        final boolean[] modified = new boolean[1];
        this.consumers.executeWrites(new Runnable(){

            public void run() {
                Iterator it = ServerDestination.this.consumers.iterator();
                while (it.hasNext()) {
                    ServerConsumer consumer = (ServerConsumer)it.next();
                    if (consumer.getID() != consumerID) continue;
                    it.remove();
                    modified[0] = true;
                    return;
                }
            }
        });
        return modified[0];
    }

    public void handleClientMessage(IStoreTransaction transaction, MessageImpl message) {
        if (this.type == IDestination.Type.QUEUE) {
            ServerConsumer consumer = (ServerConsumer)this.consumers.element();
            if (consumer != null) {
                consumer.handleClientMessage(transaction, message);
            }
        } else {
            ServerConsumer[] consumers;
            ServerConsumer[] serverConsumerArray = consumers = (ServerConsumer[])this.consumers.toArray((Object[])new ServerConsumer[0]);
            int n = consumers.length;
            int n2 = 0;
            while (n2 < n) {
                ServerConsumer consumer = serverConsumerArray[n2];
                consumer.handleClientMessage(transaction, message);
                ++n2;
            }
        }
    }
}

