/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.commands.CreationCommandRegistry;
import org.eclipse.papyrus.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.infra.viewpoints.configuration.Category;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.uml.diagram.wizards.Activator;
import org.eclipse.papyrus.uml.diagram.wizards.kind.DiagramKindComposite;
import org.eclipse.papyrus.uml.diagram.wizards.kind.DiagramKindLabelProvider;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.profile.ProfileChooserComposite;
import org.eclipse.papyrus.uml.diagram.wizards.template.ModelTemplateDescription;
import org.eclipse.papyrus.uml.diagram.wizards.template.SelectModelTemplateComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.NamedElement;

public class SelectDiagramKindPage
extends WizardPage {
    public static final String PAGE_ID = "SelectDiagramKind";
    private Text nameText;
    private SelectModelTemplateComposite selectTemplateComposite;
    private DiagramKindComposite diagramKindComposite;
    private ProfileChooserComposite profileChooserComposite;
    private final CategoryProvider myCategoryProvider;
    private final boolean allowTemplates;
    private final ICreationCommandRegistry myCreationCommandRegistry;
    private static EObject modelRoot;
    public static final ICreationCommandRegistry DEFAULT_CREATION_COMMAND_REGISTRY;

    static {
        DEFAULT_CREATION_COMMAND_REGISTRY = CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.infra.ui");
    }

    public SelectDiagramKindPage(CategoryProvider categoryProvider) {
        this(true, categoryProvider, DEFAULT_CREATION_COMMAND_REGISTRY);
    }

    public SelectDiagramKindPage(boolean allowTemplates, CategoryProvider categoryProvider, ICreationCommandRegistry creationCommandRegistry) {
        super(PAGE_ID);
        this.setTitle(Messages.SelectDiagramKindPage_page_title);
        this.setDescription(Messages.SelectDiagramKindPage_page_desc);
        this.allowTemplates = allowTemplates;
        this.myCategoryProvider = categoryProvider;
        this.myCreationCommandRegistry = creationCommandRegistry;
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        pageComposite.setLayout((Layout)new GridLayout());
        pageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        String[] categories = this.getDiagramCategories();
        Composite nameFormComposite = new Composite(pageComposite, 0);
        nameFormComposite.setLayout((Layout)new GridLayout());
        nameFormComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createNameForm(nameFormComposite);
        Composite diagramKindComposite = new Composite(pageComposite, 0);
        diagramKindComposite.setLayout((Layout)new GridLayout());
        diagramKindComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDiagramKindForm(diagramKindComposite);
        this.diagramKindComposite.setInput(categories);
        Composite modelTemplateComposite = new Composite(pageComposite, 0);
        modelTemplateComposite.setLayout((Layout)new GridLayout());
        modelTemplateComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createModelTemplateComposite(modelTemplateComposite);
        this.fillInTables(categories);
        Composite profileChooserComposite = new Composite(pageComposite, 0);
        profileChooserComposite.setLayout((Layout)new GridLayout());
        profileChooserComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createProfileFileChooser(profileChooserComposite);
        this.setControl((Control)pageComposite);
    }

    private void createProfileFileChooser(Composite parent) {
        Group group = SelectDiagramKindPage.createGroup(parent, Messages.SelectDiagramKindPage_0);
        this.profileChooserComposite = new ProfileChooserComposite((Composite)group);
    }

    public String getProfileURI() {
        return this.profileChooserComposite.getProfileURI();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fillInTables(this.getDiagramCategories());
            this.validatePage();
            Combo templateCombo = this.selectTemplateComposite.getTemplateCombo();
            if (templateCombo.getItemCount() == 0) {
                templateCombo.setEnabled(false);
            } else {
                templateCombo.setEnabled(true);
            }
            if (!this.allowTemplates) {
                this.selectTemplateComposite.disable();
            }
        }
    }

    private void fillInTables(String[] categories) {
        if (categories == null || categories.length == 0) {
            return;
        }
        this.diagramKindComposite.setInput(categories);
        this.selectTemplateComposite.setInput(categories);
        this.getShell().pack(true);
    }

    public String getTemplatePath() {
        return this.selectTemplateComposite.getTemplatePath();
    }

    public String getNotationTemplatePath() {
        return this.selectTemplateComposite.getNotationTemplatePath();
    }

    public String getDiTemplatePath() {
        return this.selectTemplateComposite.getDiTemplatePath();
    }

    public String getTemplatePluginId() {
        return this.selectTemplateComposite.getTemplatePluginId();
    }

    private String[] getDiagramCategories() {
        return this.myCategoryProvider.getCurrentCategories();
    }

    public List<String> getDiagramName() {
        return this.diagramKindComposite.getDiagramName();
    }

    public String getRootElementName() {
        return this.nameText.getText();
    }

    public boolean templatesEnabled() {
        return this.allowTemplates;
    }

    public List<ViewPrototype> getSelectedPrototypes(String categoryId) {
        ViewPrototype[] selected = this.getSelectedPrototypes();
        ArrayList<ViewPrototype> commands = new ArrayList<ViewPrototype>();
        int i = 0;
        while (i < selected.length) {
            for (Category category : selected[i].getCategories()) {
                if (!category.getName().equals(categoryId)) continue;
                commands.add(selected[i]);
                break;
            }
            ++i;
        }
        return commands;
    }

    private void createModelTemplateComposite(Composite composite) {
        Group group = SelectDiagramKindPage.createGroup(composite, Messages.SelectDiagramKindPage_load_template_group);
        this.selectTemplateComposite = new SelectModelTemplateComposite((Composite)group);
    }

    private void createDiagramKindForm(Composite composite) {
        Group group = SelectDiagramKindPage.createGroup(composite, Messages.SelectDiagramKindPage_select_kind_group);
        this.diagramKindComposite = new DiagramKindComposite((Composite)group);
    }

    protected IBaseLabelProvider createDiagramKindLabelProvider() {
        return new DiagramKindLabelProvider();
    }

    private static Group createGroup(Composite parent, String name) {
        Group group = new Group(parent, 0);
        group.setText(name);
        GridLayout layout = new GridLayout(1, true);
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        group.setLayoutData((Object)data);
        return group;
    }

    private void createNameForm(Composite composite) {
        IFile selectedIFile;
        IStructuredSelection sSelection;
        Object selectedObject;
        Group group = SelectDiagramKindPage.createGroup(composite, Messages.SelectDiagramKindPage_diagram_name_group);
        this.nameText = new Text((Composite)group, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameText.setText(Messages.SelectDiagramKindPage_default_diagram_name);
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0 && (selectedObject = (sSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (selectedIFile = (IFile)((IAdaptable)selectedObject).getAdapter(IFile.class)) != null) {
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.getResource(URI.createURI((String)selectedIFile.getLocationURI().toString()), true);
                if (resource.getContents().size() > 0) {
                    modelRoot = (EObject)resource.getContents().get(0);
                    if (modelRoot instanceof NamedElement) {
                        NamedElement element = (NamedElement)modelRoot;
                        this.nameText.setText(element.getName());
                    } else {
                        modelRoot = null;
                    }
                }
            }
            catch (Exception e) {
                this.setErrorMessage(Messages.SelectDiagramKindPage_Set_Root_Name_Error);
                Activator.log.error((Throwable)e);
            }
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectDiagramKindPage.this.validatePage();
            }
        });
    }

    public static EObject getModelRoot() {
        return modelRoot;
    }

    private boolean validatePage() {
        return this.diagramKindComposite.getDiagramName().size() != 0;
    }

    public String[] getSelectedDiagramKinds(String categoryId) {
        return new String[0];
    }

    protected ViewPrototype[] getSelectedPrototypes() {
        ArrayList<ViewPrototype> checked = this.diagramKindComposite.getCheckElement();
        ViewPrototype[] result = checked.toArray(new ViewPrototype[checked.size()]);
        return result;
    }

    protected final ICreationCommandRegistry getCreationCommandRegistry() {
        return this.myCreationCommandRegistry;
    }

    public List<ModelTemplateDescription> getTemplateTransfo() {
        return this.selectTemplateComposite.getTemplateTransfoPath();
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.papyrus.uml.diagram.wizards.Kind");
    }

    public static interface CategoryProvider {
        public String[] getCurrentCategories();
    }
}

