/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingAuditSupport;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.HorizontalBranchingMappingStrategyWithRanges;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalBranchingClassMapping
extends AbstractHorizontalClassMapping
implements IClassMappingAuditSupport,
IClassMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HorizontalBranchingClassMapping.class);
    private String sqlInsertAttributes;
    private String sqlSelectCurrentAttributes;
    private String sqlSelectAllObjectIDs;
    private String sqlSelectAttributesByTime;
    private String sqlSelectAttributesByVersion;
    private String sqlReviseAttributes;
    private String sqlSelectForHandle;
    private String sqlSelectForChangeSet;
    private String sqlRawDeleteAttributes;
    private ThreadLocal<FeatureDeltaWriter> deltaWriter = new ThreadLocal<FeatureDeltaWriter>(){

        @Override
        protected FeatureDeltaWriter initialValue() {
            return new FeatureDeltaWriter();
        }
    };

    public HorizontalBranchingClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        super(mappingStrategy, eClass);
        this.initSQLStrings();
    }

    @Override
    protected IDBField addBranchField(IDBTable table) {
        return table.addField("CDO_BRANCH", DBType.INTEGER, true);
    }

    private void initSQLStrings() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("CDO_VERSION");
        builder.append(", ");
        builder.append("CDO_CREATED");
        builder.append(", ");
        builder.append("CDO_REVISED");
        builder.append(", ");
        builder.append("CDO_RESOURCE");
        builder.append(", ");
        builder.append("CDO_CONTAINER");
        builder.append(", ");
        builder.append("CDO_FEATURE");
        HorizontalBranchingClassMapping.appendTypeMappingNames(builder, this.getValueMappings());
        HorizontalBranchingClassMapping.appendFieldNames(builder, this.getUnsettableFields());
        HorizontalBranchingClassMapping.appendFieldNames(builder, this.getListSizeFields());
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("CDO_ID");
        builder.append("=? AND ");
        builder.append("CDO_BRANCH");
        builder.append("=? AND (");
        String sqlSelectAttributesPrefix = builder.toString();
        builder.append("CDO_REVISED");
        builder.append("=0)");
        this.sqlSelectCurrentAttributes = builder.toString();
        builder = new StringBuilder(sqlSelectAttributesPrefix);
        builder.append("CDO_CREATED");
        builder.append("<=? AND (");
        builder.append("CDO_REVISED");
        builder.append("=0 OR ");
        builder.append("CDO_REVISED");
        builder.append(">=?))");
        this.sqlSelectAttributesByTime = builder.toString();
        builder = new StringBuilder(sqlSelectAttributesPrefix);
        builder.append("ABS(");
        builder.append("CDO_VERSION");
        builder.append(")=?)");
        this.sqlSelectAttributesByVersion = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable());
        builder.append("(");
        builder.append("CDO_ID");
        builder.append(", ");
        builder.append("CDO_VERSION");
        builder.append(", ");
        builder.append("CDO_BRANCH");
        builder.append(", ");
        builder.append("CDO_CREATED");
        builder.append(", ");
        builder.append("CDO_REVISED");
        builder.append(", ");
        builder.append("CDO_RESOURCE");
        builder.append(", ");
        builder.append("CDO_CONTAINER");
        builder.append(", ");
        builder.append("CDO_FEATURE");
        HorizontalBranchingClassMapping.appendTypeMappingNames(builder, this.getValueMappings());
        HorizontalBranchingClassMapping.appendFieldNames(builder, this.getUnsettableFields());
        HorizontalBranchingClassMapping.appendFieldNames(builder, this.getListSizeFields());
        builder.append(") VALUES (?, ?, ?, ?, ?, ?, ?, ?");
        HorizontalBranchingClassMapping.appendTypeMappingParameters(builder, this.getValueMappings());
        HorizontalBranchingClassMapping.appendFieldParameters(builder, this.getUnsettableFields());
        HorizontalBranchingClassMapping.appendFieldParameters(builder, this.getListSizeFields());
        builder.append(")");
        this.sqlInsertAttributes = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append("CDO_REVISED");
        builder.append("=? WHERE ");
        builder.append("CDO_ID");
        builder.append("=? AND ");
        builder.append("CDO_BRANCH");
        builder.append("=? AND ");
        builder.append("CDO_REVISED");
        builder.append("=0");
        this.sqlReviseAttributes = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("CDO_ID");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("CDO_REVISED");
        builder.append("=0");
        this.sqlSelectAllObjectIDs = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append("CDO_ID");
        builder.append(", ");
        builder.append("CDO_VERSION");
        builder.append(", ");
        builder.append("CDO_BRANCH");
        builder.append(" FROM ");
        builder.append(this.getTable());
        this.sqlSelectForHandle = builder.toString();
        builder = new StringBuilder("SELECT DISTINCT ");
        builder.append("CDO_ID");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        this.sqlSelectForChangeSet = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("CDO_ID");
        builder.append("=? AND ");
        builder.append("CDO_BRANCH");
        builder.append("=? AND ");
        builder.append("CDO_VERSION");
        builder.append("=?");
        this.sqlRawDeleteAttributes = builder.toString();
    }

    @Override
    public boolean readRevision(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        long timeStamp = revision.getTimeStamp();
        int branchID = revision.getBranch().getID();
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = null;
        boolean success = false;
        try {
            try {
                if (timeStamp != 0L) {
                    stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectAttributesByTime, IDBPreparedStatement.ReuseProbability.MEDIUM);
                    idHandler.setCDOID((PreparedStatement)stmt, 1, revision.getID());
                    stmt.setInt(2, branchID);
                    stmt.setLong(3, timeStamp);
                    stmt.setLong(4, timeStamp);
                } else {
                    stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectCurrentAttributes, IDBPreparedStatement.ReuseProbability.HIGH);
                    idHandler.setCDOID((PreparedStatement)stmt, 1, revision.getID());
                    stmt.setInt(2, branchID);
                }
                success = this.readValuesFromStatement((PreparedStatement)stmt, revision, accessor);
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(stmt);
            throw throwable;
        }
        DBUtil.close((Statement)stmt);
        if (success && revision.getVersion() >= 1) {
            this.readLists(accessor, revision, listChunk);
        }
        return success;
    }

    @Override
    public boolean readRevisionByVersion(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlSelectAttributesByVersion, IDBPreparedStatement.ReuseProbability.HIGH);
        boolean success = false;
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, revision.getID());
                stmt.setInt(2, revision.getBranch().getID());
                stmt.setInt(3, revision.getVersion());
                success = this.readValuesFromStatement((PreparedStatement)stmt, revision, accessor);
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
        if (success) {
            this.readLists(accessor, revision, listChunk);
        }
        return success;
    }

    public IDBPreparedStatement createResourceQueryStatement(IDBStoreAccessor accessor, CDOID folderId, String name, boolean exactMatch, CDOBranchPoint branchPoint) {
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        ITypeMapping nameValueMapping = this.getValueMapping((EStructuralFeature)nameFeature);
        if (nameValueMapping == null) {
            throw new ImplementationError(nameFeature + " not found in ClassMapping " + this);
        }
        int branchID = branchPoint.getBranch().getID();
        long timeStamp = branchPoint.getTimeStamp();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append("CDO_ID");
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append("CDO_VERSION");
        builder.append(">0 AND ");
        builder.append("CDO_BRANCH");
        builder.append("=? AND ");
        builder.append("CDO_CONTAINER");
        builder.append("=? AND ");
        builder.append(nameValueMapping.getField());
        if (name == null) {
            builder.append(" IS NULL");
        } else {
            builder.append(exactMatch ? " =?" : " LIKE ?");
        }
        builder.append(" AND (");
        if (timeStamp == 0L) {
            builder.append("CDO_REVISED");
            builder.append("=0)");
        } else {
            builder.append("CDO_CREATED");
            builder.append("<=? AND (");
            builder.append("CDO_REVISED");
            builder.append("=0 OR ");
            builder.append("CDO_REVISED");
            builder.append(">=?))");
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(builder.toString(), IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            int column = 1;
            stmt.setInt(column++, branchID);
            idHandler.setCDOID((PreparedStatement)stmt, column++, folderId);
            if (name != null) {
                String queryName = exactMatch ? name : String.valueOf(name) + "%";
                nameValueMapping.setValue((PreparedStatement)stmt, column++, queryName);
            }
            if (timeStamp != 0L) {
                stmt.setLong(column++, timeStamp);
                stmt.setLong(column++, timeStamp);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Created Resource Query: {0}", new Object[]{stmt.toString()});
            }
            return stmt;
        }
        catch (SQLException ex) {
            DBUtil.close((Statement)stmt);
            throw new DBException((Throwable)ex);
        }
    }

    public IDBPreparedStatement createObjectIDStatement(IDBStoreAccessor accessor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Created ObjectID Statement : {0}", new Object[]{this.sqlSelectAllObjectIDs});
        }
        return accessor.getDBConnection().prepareStatement(this.sqlSelectAllObjectIDs, IDBPreparedStatement.ReuseProbability.HIGH);
    }

    @Override
    protected final void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsertAttributes, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, revision.getID());
                stmt.setInt(column++, revision.getVersion());
                stmt.setInt(column++, revision.getBranch().getID());
                stmt.setLong(column++, revision.getTimeStamp());
                stmt.setLong(column++, revision.getRevised());
                idHandler.setCDOID((PreparedStatement)stmt, column++, revision.getResourceID());
                idHandler.setCDOID((PreparedStatement)stmt, column++, (CDOID)revision.getContainerID());
                stmt.setInt(column++, revision.getContainingFeatureID());
                int isSetCol = column + this.getValueMappings().size();
                for (ITypeMapping mapping : this.getValueMappings()) {
                    EStructuralFeature feature = mapping.getFeature();
                    if (feature.isUnsettable()) {
                        if (revision.getValue(feature) == null) {
                            stmt.setBoolean(isSetCol++, false);
                            mapping.setDefaultValue((PreparedStatement)stmt, column++);
                            continue;
                        }
                        stmt.setBoolean(isSetCol++, true);
                    }
                    mapping.setValueFromRevision((PreparedStatement)stmt, column++, revision);
                }
                Map<EStructuralFeature, IDBField> listSizeFields = this.getListSizeFields();
                if (listSizeFields != null) {
                    column = isSetCol;
                    for (EStructuralFeature feature : listSizeFields.keySet()) {
                        CDOList list = revision.getList(feature);
                        stmt.setInt(column++, list.size());
                    }
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    protected void detachAttributes(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, long timeStamp, OMMonitor mon) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsertAttributes, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, id);
                stmt.setInt(column++, -version);
                stmt.setInt(column++, branch.getID());
                stmt.setLong(column++, timeStamp);
                stmt.setLong(column++, 0L);
                idHandler.setCDOID((PreparedStatement)stmt, column++, CDOID.NULL);
                idHandler.setCDOID((PreparedStatement)stmt, column++, CDOID.NULL);
                stmt.setInt(column++, 0);
                int isSetCol = column + this.getValueMappings().size();
                for (ITypeMapping mapping : this.getValueMappings()) {
                    EStructuralFeature feature = mapping.getFeature();
                    if (feature.isUnsettable()) {
                        stmt.setBoolean(isSetCol++, false);
                    }
                    mapping.setDefaultValue((PreparedStatement)stmt, column++);
                }
                Map<EStructuralFeature, IDBField> listSizeFields = this.getListSizeFields();
                if (listSizeFields != null) {
                    column = isSetCol;
                    int i = 0;
                    while (i < listSizeFields.size()) {
                        stmt.setInt(column++, 0);
                        ++i;
                    }
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    protected void rawDeleteAttributes(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version, OMMonitor fork) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlRawDeleteAttributes, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                stmt.setInt(2, branch.getID());
                stmt.setInt(3, version);
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    protected void reviseOldRevision(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, long revised) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlReviseAttributes, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                stmt.setLong(1, revised);
                idHandler.setCDOID((PreparedStatement)stmt, 2, id);
                stmt.setInt(3, branch.getID());
                DBUtil.update((PreparedStatement)stmt, (boolean)false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public void writeRevision(IDBStoreAccessor accessor, InternalCDORevision revision, boolean mapType, boolean revise, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin(10.0);
        try {
            try {
                async = monitor.forkAsync();
                CDOID id = revision.getID();
                if (mapType) {
                    long timeStamp = revision.getTimeStamp();
                    EClass eClass = this.getEClass();
                    AbstractHorizontalMappingStrategy mappingStrategy = (AbstractHorizontalMappingStrategy)this.getMappingStrategy();
                    if (!mappingStrategy.putObjectType(accessor, timeStamp, id, eClass)) {
                        mapType = false;
                    }
                }
                if (!mapType && revise && revision.getVersion() > 1) {
                    long revised = revision.getTimeStamp() - 1L;
                    InternalCDOBranch branch = revision.getBranch();
                    this.reviseOldRevision(accessor, id, (CDOBranch)branch, revised);
                    for (IListMapping mapping : this.getListMappings()) {
                        mapping.objectDetached(accessor, id, revised);
                    }
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                async = monitor.forkAsync();
                if (revision.isResourceNode()) {
                    this.checkDuplicateResources(accessor, (CDORevision)revision);
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                async = monitor.forkAsync();
                this.writeValues(accessor, revision);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
            try {
                async = monitor.forkAsync(7.0);
                if (this.getListMappings() != null) {
                    this.writeLists(accessor, revision);
                }
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void handleRevisions(IDBStoreAccessor accessor, CDOBranch branch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        StringBuilder builder = new StringBuilder(this.sqlSelectForHandle);
        boolean whereAppend = false;
        if (branch != null) {
            builder.append(" WHERE ");
            builder.append("CDO_BRANCH");
            builder.append("=?");
            whereAppend = true;
        }
        int timeParameters = 0;
        if (timeStamp != -1L) {
            if (exactTime) {
                if (timeStamp != 0L) {
                    builder.append(whereAppend ? " AND " : " WHERE ");
                    builder.append("CDO_CREATED");
                    builder.append("=?");
                    timeParameters = 1;
                }
            } else {
                builder.append(whereAppend ? " AND " : " WHERE ");
                if (timeStamp != 0L) {
                    builder.append("CDO_CREATED");
                    builder.append("<=? AND (");
                    builder.append("CDO_REVISED");
                    builder.append("=0 OR ");
                    builder.append("CDO_REVISED");
                    builder.append(">=?)");
                    timeParameters = 2;
                } else {
                    builder.append("CDO_REVISED");
                    builder.append("=0");
                }
            }
        }
        IRepository repository = accessor.getStore().getRepository();
        CDORevisionManager revisionManager = repository.getRevisionManager();
        CDOBranchManager branchManager = repository.getBranchManager();
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(builder.toString(), IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        try {
            try {
                int column = 1;
                if (branch != null) {
                    stmt.setInt(column++, branch.getID());
                }
                int i = 0;
                while (i < timeParameters) {
                    stmt.setLong(column++, timeStamp);
                    ++i;
                }
                resultSet = stmt.executeQuery();
                while (resultSet.next()) {
                    CDOID id = idHandler.getCDOID((ResultSet)resultSet, 1);
                    int version = resultSet.getInt(2);
                    if (version >= 1) {
                        int branchID = resultSet.getInt(3);
                        CDOBranchVersion branchVersion = branchManager.getBranch(branchID).getVersion(Math.abs(version));
                        InternalCDORevision revision = (InternalCDORevision)revisionManager.getRevisionByVersion(id, branchVersion, -1, true);
                        if (handler.handleRevision((CDORevision)revision)) continue;
                        break;
                    }
                    DetachedCDORevision revision = new DetachedCDORevision(null, id, null, version, 0L);
                    handler.handleRevision((CDORevision)revision);
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(resultSet);
            DBUtil.close((Statement)stmt);
            throw throwable;
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
    }

    @Override
    public Set<CDOID> readChangeSet(IDBStoreAccessor accessor, CDOChangeSetSegment[] segments) {
        HashSet<CDOID> hashSet;
        StringBuilder builder = new StringBuilder(this.sqlSelectForChangeSet);
        boolean isFirst = true;
        int i = 0;
        while (i < segments.length) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(" OR ");
            }
            builder.append("CDO_BRANCH");
            builder.append("=? AND ");
            builder.append("CDO_CREATED");
            builder.append(">=?");
            builder.append(" AND (");
            builder.append("CDO_REVISED");
            builder.append("<=? OR ");
            builder.append("CDO_REVISED");
            builder.append("=0)");
            ++i;
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(builder.toString(), IDBPreparedStatement.ReuseProbability.LOW);
        IDBResultSet resultSet = null;
        HashSet<CDOID> result = new HashSet<CDOID>();
        try {
            int column = 1;
            CDOChangeSetSegment[] cDOChangeSetSegmentArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                CDOChangeSetSegment segment = cDOChangeSetSegmentArray[n2];
                stmt.setInt(column++, segment.getBranch().getID());
                stmt.setLong(column++, segment.getTimeStamp());
                stmt.setLong(column++, segment.getEndTime());
                ++n2;
            }
            resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                CDOID id = idHandler.getCDOID((ResultSet)resultSet, 1);
                result.add(id);
            }
            hashSet = result;
        }
        catch (SQLException e) {
            try {
                throw new DBException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(resultSet);
                DBUtil.close((Statement)stmt);
                throw throwable;
            }
        }
        DBUtil.close((ResultSet)resultSet);
        DBUtil.close((Statement)stmt);
        return hashSet;
    }

    @Override
    protected String getListXRefsWhere(IStoreAccessor.QueryXRefsContext context) {
        StringBuilder builder = new StringBuilder();
        builder.append("CDO_BRANCH");
        builder.append("=");
        builder.append(context.getBranch().getID());
        builder.append(" AND (");
        long timeStamp = context.getTimeStamp();
        if (timeStamp == 0L) {
            builder.append("CDO_REVISED");
            builder.append("=0)");
        } else {
            builder.append("CDO_CREATED");
            builder.append("<=");
            builder.append(timeStamp);
            builder.append(" AND (");
            builder.append("CDO_REVISED");
            builder.append("=0 OR ");
            builder.append("CDO_REVISED");
            builder.append(">=");
            builder.append(timeStamp);
            builder.append("))");
        }
        return builder.toString();
    }

    @Override
    public void writeRevisionDelta(IDBStoreAccessor accessor, InternalCDORevisionDelta delta, long created, OMMonitor monitor) {
        monitor.begin();
        try {
            if (accessor.getTransaction().getBranch() != delta.getBranch() && ((HorizontalBranchingMappingStrategyWithRanges)this.getMappingStrategy()).shallCopyOnBranch()) {
                this.doCopyOnBranch(accessor, delta, created, monitor.fork());
                return;
            }
            OMMonitor.Async async = null;
            try {
                async = monitor.forkAsync();
                FeatureDeltaWriter writer = this.deltaWriter.get();
                writer.process(accessor, delta, created);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void doCopyOnBranch(IDBStoreAccessor accessor, InternalCDORevisionDelta delta, long created, OMMonitor monitor) {
        monitor.begin(2.0);
        try {
            InternalRepository repository = (InternalRepository)accessor.getStore().getRepository();
            InternalCDORevision oldRevision = (InternalCDORevision)accessor.getTransaction().getRevision(delta.getID());
            if (oldRevision == null) {
                throw new IllegalStateException("Origin revision not found for " + delta);
            }
            repository.ensureChunks(oldRevision, -1);
            InternalCDORevision newRevision = oldRevision.copy();
            newRevision.adjustForCommit(accessor.getTransaction().getBranch(), created);
            delta.applyTo((CDORevision)newRevision);
            monitor.worked();
            this.writeRevision(accessor, newRevision, false, true, monitor.fork());
        }
        finally {
            monitor.done();
        }
    }

    private class FeatureDeltaWriter
    implements CDOFeatureDeltaVisitor {
        private IDBStoreAccessor accessor;
        private long created;
        private CDOID id;
        private CDOBranch targetBranch;
        private int oldVersion;
        private int newVersion;
        private InternalCDORevision newRevision;

        private FeatureDeltaWriter() {
        }

        public void process(IDBStoreAccessor accessor, InternalCDORevisionDelta delta, long created) {
            this.accessor = accessor;
            this.created = created;
            this.id = delta.getID();
            this.oldVersion = delta.getVersion();
            if (TRACER.isEnabled()) {
                TRACER.format("FeatureDeltaWriter: old version: {0}, new version: {1}", new Object[]{this.oldVersion, this.oldVersion + 1});
            }
            InternalCDORevision originalRevision = (InternalCDORevision)accessor.getTransaction().getRevision(this.id);
            this.newRevision = originalRevision.copy();
            this.targetBranch = accessor.getTransaction().getBranch();
            this.newRevision.adjustForCommit(this.targetBranch, created);
            this.newVersion = this.newRevision.getVersion();
            delta.accept((CDOFeatureDeltaVisitor)this);
            if (this.newVersion != 1) {
                HorizontalBranchingClassMapping.this.reviseOldRevision(accessor, this.id, delta.getBranch(), this.newRevision.getTimeStamp() - 1L);
            }
            HorizontalBranchingClassMapping.this.writeValues(accessor, this.newRevision);
        }

        public void visit(CDOMoveFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOAddFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDORemoveFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOSetFeatureDelta delta) {
            delta.applyTo((CDORevision)this.newRevision);
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            delta.applyTo((CDORevision)this.newRevision);
        }

        public void visit(CDOListFeatureDelta delta) {
            delta.applyTo((CDORevision)this.newRevision);
            IListMappingDeltaSupport listMapping = (IListMappingDeltaSupport)((Object)HorizontalBranchingClassMapping.this.getListMapping(delta.getFeature()));
            listMapping.processDelta(this.accessor, this.id, this.targetBranch.getID(), this.oldVersion, this.newVersion, this.created, delta);
        }

        public void visit(CDOClearFeatureDelta delta) {
            throw new ImplementationError("Should not be called");
        }

        public void visit(CDOContainerFeatureDelta delta) {
            delta.applyTo((CDORevision)this.newRevision);
        }
    }
}

