/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.core.admin;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.cdo.admin.CDOAdminClient;
import org.eclipse.emf.cdo.common.admin.CDOAdminRepository;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.papyrus.cdo.core.admin.IPapyrusRepositoryAdminListener;
import org.eclipse.papyrus.cdo.core.admin.PapyrusRepositoryAdminEvent;
import org.eclipse.papyrus.cdo.internal.core.Activator;

public class PapyrusRepositoryAdminManager
extends ContainerEventAdapter<CDOAdminClient> {
    private final RepositoryListener repositoryListener = new RepositoryListener();
    private final CopyOnWriteArrayList<IPapyrusRepositoryAdminListener> listeners = new CopyOnWriteArrayList();
    private final Map<CDOAdminRepository, String> repositories = Maps.newConcurrentMap();

    public PapyrusRepositoryAdminManager() {
        super(true);
    }

    public void install(IContainer<? extends CDOAdminClient> container) {
        container.addListener((IListener)this);
        CDOAdminClient[] cDOAdminClientArray = (CDOAdminClient[])container.getElements();
        int n = cDOAdminClientArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOAdminClient next = cDOAdminClientArray[n2];
            next.addListener((IListener)this.repositoryListener);
            ++n2;
        }
    }

    protected void onAdded(IContainer<CDOAdminClient> container, CDOAdminClient element) {
        element.addListener((IListener)this.repositoryListener);
    }

    protected void onRemoved(IContainer<CDOAdminClient> container, CDOAdminClient element) {
        element.removeListener((IListener)this.repositoryListener);
    }

    public void addRepositoryAdminListener(IPapyrusRepositoryAdminListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeRepositoryAdminListener(IPapyrusRepositoryAdminListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireRepositoryAdminEvent(int eventType, String url, String name) {
        if (!this.listeners.isEmpty()) {
            PapyrusRepositoryAdminEvent event = new PapyrusRepositoryAdminEvent(this, eventType, url, name);
            for (IPapyrusRepositoryAdminListener next : this.listeners) {
                try {
                    switch (eventType) {
                        case 0: {
                            next.repositoryAdded(event);
                            break;
                        }
                        case 1: {
                            next.repositoryRemoved(event);
                        }
                    }
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in repository admin listener.", (Throwable)e);
                }
            }
        }
    }

    private class RepositoryListener
    extends ContainerEventAdapter<CDOAdminRepository> {
        private RepositoryListener() {
        }

        protected void onAdded(IContainer<CDOAdminRepository> container, CDOAdminRepository element) {
            if (container instanceof CDOAdminClient) {
                CDOAdminClient client = (CDOAdminClient)container;
                String url = String.format("%s?repositoryName=%s", client.getURL(), element.getName());
                PapyrusRepositoryAdminManager.this.repositories.put(element, url);
                if (client.isConnected()) {
                    PapyrusRepositoryAdminManager.this.fireRepositoryAdminEvent(0, url, element.getName());
                }
            }
        }

        protected void onRemoved(IContainer<CDOAdminRepository> container, CDOAdminRepository element) {
            if (container instanceof CDOAdminClient) {
                CDOAdminClient client = (CDOAdminClient)container;
                String url = (String)PapyrusRepositoryAdminManager.this.repositories.remove(element);
                if (url != null && client.isConnected()) {
                    PapyrusRepositoryAdminManager.this.fireRepositoryAdminEvent(1, url, element.getName());
                }
            }
        }
    }
}

