/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.core.importer;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.importer.IModelImportMapping;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferNode;
import org.eclipse.papyrus.cdo.internal.core.importer.AbstractModelTransferMapping;
import org.eclipse.papyrus.cdo.internal.core.l10n.Messages;

abstract class AbstractModelImportMapping
extends AbstractModelTransferMapping
implements IModelImportMapping {
    public AbstractModelImportMapping(IModelTransferConfiguration config) {
        super(config);
    }

    @Override
    protected boolean validateMapping(IModelTransferNode node, DiagnosticChain diagnostics) {
        boolean result = true;
        IPath mapping = this.getMapping(node);
        if (mapping == null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, NLS.bind((String)Messages.AbstractModelImportMapping_0, (Object)node.getName()), new Object[]{node}));
            result = false;
        } else {
            for (URI next : node.getResourceURIs()) {
                String resourcePath = mapping.removeFileExtension().addFileExtension(next.fileExtension()).toString();
                if (!this.getView().hasResource(resourcePath)) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.cdo.core", 0, NLS.bind((String)Messages.AbstractModelImportMapping_1, (Object)mapping, (Object)node.getName()), new Object[]{node}));
                result = false;
                break;
            }
        }
        return result;
    }

    protected CDOView getView() {
        CDOCheckout checkout = this.getCheckout();
        return checkout == null ? null : checkout.getView();
    }

    @Override
    protected void computeDefaultMappings(IModelTransferConfiguration configuration) {
        for (IModelTransferNode next : configuration.getModelsToTransfer()) {
            if (this.getMapping(next) != null) continue;
            this.mapTo(next, (IPath)new Path(next.getName()));
        }
    }
}

