/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionChangeRecorder;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.AbstractModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.Activator;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.providers.DecoratorPackageCache;
import org.eclipse.papyrus.uml.tools.listeners.ProfileApplicationListener;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;

public class DecoratorModel
extends AbstractModel {
    public static final String ID = "org.eclipse.papyrus.uml.decoratormodel.DecoratorModel";
    private URI creatingDecoratorModelURI;

    public String getIdentifier() {
        return ID;
    }

    public void init(ModelSet modelSet) {
        super.init(modelSet);
        DecoratorModelUtils.configure((ResourceSet)modelSet);
    }

    protected ModelSet getModelManager() {
        return super.getModelManager();
    }

    public void loadModel(IPath path) {
        this.loadModel(this.getPlatformURI(path));
    }

    protected URI getPlatformURI(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public void loadModel(URI uri) {
        List<Resource> resources = this.getResources();
        for (Resource resource : resources) {
            try {
                if (!resource.isLoaded()) {
                    resource.load(null);
                }
                EcoreUtil.resolveAll((Resource)resource);
                this.configureResource(resource);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
        this.startSnippets();
    }

    protected List<Resource> getResources() {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)0);
        for (Resource next : ImmutableList.copyOf((Collection)this.getModelManager().getResources())) {
            URI trimmed;
            if (!this.isDecoratorModelResource(next) || !(trimmed = next.getURI().trimFileExtension()).equals(this.getModelManager().getURIWithoutExtension())) continue;
            result.add(next);
        }
        return result;
    }

    public boolean isDecoratorModelResource(Resource resource) {
        return DecoratorModel.isDecoratorModel(resource) || resource.getURI().equals(this.creatingDecoratorModelURI);
    }

    protected void configureResource(Resource resource) {
        if (resource instanceof XMIResource) {
            ((XMIResource)resource).getDefaultSaveOptions().putAll(this.getSaveOptions());
            ((XMIResource)resource).setEncoding("UTF-8");
        }
    }

    public Map<Object, Object> getSaveOptions() {
        return AbstractBaseModel.getDefaultSaveOptions();
    }

    public void saveModel() throws IOException {
        List<Resource> resources = this.getResources();
        for (Resource resource : resources) {
            if (this.getModelManager().getTransactionalEditingDomain().isReadOnly(resource) || ModelUtils.resourceFailedOnLoad((Resource)resource)) continue;
            resource.save(this.getSaveOptions());
        }
    }

    public void unload() {
        this.stopSnippets();
        List<Resource> resources = this.getResources();
        for (Resource resource : resources) {
            resource.unload();
        }
    }

    public Set<URI> getModifiedURIs() {
        HashSet result = Sets.newHashSet();
        for (Resource resource : this.getResources()) {
            if (this.getModelManager().isTrackingModification() && !resource.isModified()) continue;
            result.add(resource.getURI());
        }
        return result;
    }

    public Resource loadDecoratorModel(URI uri) {
        ModelSet resourceSet = this.getModelManager();
        Resource result = resourceSet.getResource(uri, false);
        if (result == null) {
            this.creatingDecoratorModelURI = uri;
            try {
                result = resourceSet.createResource(uri, "org.eclipse.uml2.uml");
            }
            finally {
                this.creatingDecoratorModelURI = null;
            }
        }
        if (!result.isLoaded()) {
            try {
                try {
                    this.ensureTransactionChangeRecorder(result);
                    result.load(resourceSet.getLoadOptions());
                    EcoreUtil.resolveAll((Resource)result);
                    new DecoratorPackageCache(result).install();
                }
                catch (Exception exception) {
                    this.notifyProfilesApplied(result);
                }
            }
            finally {
                this.notifyProfilesApplied(result);
            }
        }
        return result;
    }

    private void ensureTransactionChangeRecorder(Resource resource) {
        TransactionChangeRecorder recorder;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)resource);
        if (domain != null && (recorder = ((InternalTransactionalEditingDomain)domain).getChangeRecorder()) != null) {
            int afterCacheAdapter = resource.eAdapters().indexOf((Object)CacheAdapter.getCacheAdapter((Notifier)resource)) + 1;
            int index = resource.eAdapters().indexOf((Object)recorder);
            if (index < 0) {
                resource.eAdapters().add(afterCacheAdapter, (Object)recorder);
            } else {
                resource.eAdapters().move(afterCacheAdapter, index);
            }
        }
    }

    protected void notifyProfilesApplied(Resource decoratorModel) {
        Package rootPackage = (Package)EcoreUtil.getObjectByType((Collection)decoratorModel.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        if (rootPackage != null) {
            TreeIterator iter = rootPackage.eAllContents();
            while (iter.hasNext()) {
                ProfileApplication application;
                Package applyingPackage;
                Object next = iter.next();
                if (!(next instanceof ProfileApplication) || (applyingPackage = DecoratorModelUtils.getUserModelApplyingPackage(application = (ProfileApplication)next)) == application.getApplyingPackage()) continue;
                Profile appliedProfile = application.getAppliedProfile();
                ProfileApplicationListener.ProfileApplicationNotification.notifyProfileApplied((Package)applyingPackage, (Profile)appliedProfile);
            }
        }
    }

    public static boolean isDecoratorModel(Resource resource) {
        Package root;
        boolean result = false;
        if (resource.isLoaded() && (root = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE)) != null) {
            result = DecoratorModelUtils.hasExternalizationProfile(root);
        }
        return result;
    }

    public static DecoratorModel getInstance(ModelSet modelSet) {
        return (DecoratorModel)modelSet.getModel(ID);
    }

    public void createModel(IPath fullPath) {
    }

    public void createModel(URI uri) {
    }

    public void importModel(IPath path) {
    }

    public void importModel(URI uri) {
    }

    public void changeModelPath(IPath fullPath) {
    }

    public void setModelURI(URI uri) {
    }
}

