/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewDiagramResourceWizardPage;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewResourceWizardPage;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.opencert.vocabulary.diagram.part.DawnVocabularyDiagramEditorUtil;
import org.eclipse.opencert.vocabulary.diagram.part.Messages;
import org.eclipse.opencert.vocabulary.diagram.part.VocabularyCreationWizard;
import org.eclipse.opencert.vocabulary.diagram.part.VocabularyDiagramEditorPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DawnVocabularyCreationWizard
extends VocabularyCreationWizard {
    private CDOView view;
    private DawnCreateNewDiagramResourceWizardPage dawnDiagramModelFilePage;
    private DawnCreateNewResourceWizardPage dawnDomainModelFilePage;

    public DawnVocabularyCreationWizard() {
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOSession session = CDOConnectionUtil.instance.openSession();
        this.view = CDOConnectionUtil.instance.openView(session);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                URI diagramResourceURI = DawnVocabularyCreationWizard.this.dawnDiagramModelFilePage.getURI();
                URI domainModelResourceURI = DawnVocabularyCreationWizard.this.dawnDomainModelFilePage.getURI();
                DawnVocabularyCreationWizard.this.diagram = DawnVocabularyDiagramEditorUtil.createDiagram(diagramResourceURI, domainModelResourceURI, monitor);
                if (DawnVocabularyCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && DawnVocabularyCreationWizard.this.diagram != null) {
                    try {
                        DawnVocabularyDiagramEditorUtil.openDiagram(DawnVocabularyCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)DawnVocabularyCreationWizard.this.getContainer().getShell(), (String)Messages.VocabularyCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.VocabularyCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                VocabularyDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    public void addPages() {
        this.dawnDiagramModelFilePage = new DawnCreateNewDiagramResourceWizardPage("vocabulary_diagram", false, this.view);
        this.dawnDiagramModelFilePage.setTitle(Messages.VocabularyCreationWizard_DiagramModelFilePageTitle);
        this.dawnDiagramModelFilePage.setDescription(Messages.VocabularyCreationWizard_DiagramModelFilePageDescription);
        this.dawnDiagramModelFilePage.setCreateAutomaticResourceName(true);
        this.addPage((IWizardPage)this.dawnDiagramModelFilePage);
        this.dawnDomainModelFilePage = new DawnCreateNewResourceWizardPage("vocabulary", true, this.view){

            public void setVisible(boolean visible) {
                if (visible) {
                    URI uri = DawnVocabularyCreationWizard.this.dawnDiagramModelFilePage.getURI();
                    String fileName = uri.lastSegment();
                    fileName = fileName.substring(0, fileName.length() - ".vocabulary_diagram".length());
                    fileName = String.valueOf(fileName) + ".vocabulary";
                    DawnVocabularyCreationWizard.this.dawnDomainModelFilePage.setResourceNamePrefix(fileName);
                    DawnVocabularyCreationWizard.this.dawnDomainModelFilePage.setResourcePath(DawnVocabularyCreationWizard.this.dawnDiagramModelFilePage.getResourcePath());
                }
                super.setVisible(visible);
            }
        };
        this.dawnDomainModelFilePage.setTitle(Messages.VocabularyCreationWizard_DomainModelFilePageTitle);
        this.dawnDomainModelFilePage.setDescription(Messages.VocabularyCreationWizard_DomainModelFilePageDescription);
        this.dawnDomainModelFilePage.setResourceValidationType(1);
        this.addPage((IWizardPage)this.dawnDomainModelFilePage);
    }

    public void dispose() {
        this.view.close();
    }
}

