/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.edit.service;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.edit.Activator;
import org.eclipse.papyrus.infra.services.edit.internal.ElementEditServiceProvider;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;
import org.eclipse.papyrus.infra.services.edit.messages.Messages;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditServiceProvider;

public class ElementEditServiceUtils {
    public static IElementEditService getCommandProvider(Object objectToEdit) {
        try {
            return ElementEditServiceUtils.getEditServiceProvider().getEditService(objectToEdit);
        }
        catch (ServiceException e) {
            Activator.log.error(NLS.bind((String)Messages.ElementEditServiceUtils_UnableToFindElementType, (Object)objectToEdit), (Throwable)e);
        }
        catch (NullPointerException e) {
            Activator.log.error(NLS.bind((String)Messages.ElementEditServiceUtils_UnableToFindElementType, (Object)objectToEdit), (Throwable)e);
        }
        return null;
    }

    public static IElementEditServiceProvider getEditServiceProvider() {
        try {
            return ElementEditServiceUtils.getEditServiceProviderFromElementTypeRegistry();
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.ElementEditServiceUtils_UnableToFindServiceProvider, (Throwable)e);
            return null;
        }
    }

    protected static IElementEditServiceProvider getEditServiceProviderFromElementTypeRegistry() throws ServiceException {
        return ElementEditServiceProvider.getInstance();
    }

    public static EObject getTargetFromContext(TransactionalEditingDomain editingDomain, EObject owner, IEditCommandRequest editRequest) {
        GetEditContextRequest editContextRequest = new GetEditContextRequest(editingDomain, editRequest, (Object)owner);
        editContextRequest.setParameter("Cache_Maps", new HashMap());
        editContextRequest.setEditContext((Object)owner);
        try {
            editContextRequest.setClientContext(TypeContext.getContext());
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider(owner);
        if (provider == null) {
            Activator.log.debug(Messages.ElementEditServiceUtils_CantGetEditingDomainProvider);
            return null;
        }
        EObject target = owner;
        Object result = null;
        ICommand getEditContextCommand = provider.getEditCommand((IEditCommandRequest)editContextRequest);
        if (getEditContextCommand != null) {
            IStatus status = null;
            try {
                InternalTransactionalEditingDomain domain = (InternalTransactionalEditingDomain)editingDomain;
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("silent", true);
                options.put("no_validation", true);
                options.put("no_triggers", true);
                InternalTransaction transaction = domain.startTransaction(false, options);
                try {
                    status = getEditContextCommand.execute(null, null);
                }
                finally {
                    transaction.commit();
                }
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
            }
            catch (ExecutionException e) {
                Activator.log.error((Throwable)e);
            }
            catch (RollbackException e) {
                Activator.log.error((Throwable)e);
            }
            if (status != null && status.isOK()) {
                result = getEditContextCommand.getCommandResult().getReturnValue();
            }
            if (result instanceof EObject) {
                target = (EObject)result;
            }
        }
        return target;
    }

    public static EObject getTargetFromContext(EObject owner, IEditCommandRequest editRequest) {
        return ElementEditServiceUtils.getTargetFromContext(TransactionUtil.getEditingDomain((EObject)owner), owner, editRequest);
    }

    public static ICommand getCreateChildCommandWithContext(TransactionalEditingDomain editingDomain, EObject owner, IHintedType hintedType) {
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)owner);
        EObject target = ElementEditServiceUtils.getTargetFromContext(transactionalEditingDomain, owner, (IEditCommandRequest)new CreateElementRequest(transactionalEditingDomain, owner, (IElementType)hintedType));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider(target);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)new CreateElementRequest(transactionalEditingDomain, target, (IElementType)hintedType));
        return createGMFCommand;
    }

    public static ICommand getCreateChildCommandWithContext(EObject owner, IHintedType hintedType) {
        return ElementEditServiceUtils.getCreateChildCommandWithContext(TransactionUtil.getEditingDomain((EObject)owner), owner, hintedType);
    }
}

