/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.autocomplete;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.swt.custom.StyledText;

class ContentProposalListener
implements IContentProposalListener {
    private StyledText text;
    private List<Character> whiteSpace;

    public ContentProposalListener(StyledText text) {
        this.text = text;
        this.whiteSpace = new ArrayList<Character>();
        this.whiteSpace.add(Character.valueOf(' '));
        this.whiteSpace.add(Character.valueOf('\t'));
        this.whiteSpace.add(Character.valueOf('\n'));
    }

    public void proposalAccepted(IContentProposal proposal) {
        String content = this.text.getText();
        int caretOffset = this.text.getCaretOffset();
        int prevWhiteSpace = this.getprevWhiteSpace(content, caretOffset);
        StringBuilder sb = new StringBuilder();
        sb.append(content.substring(0, prevWhiteSpace + 1));
        sb.append(proposal.getContent());
        sb.append(content.substring(caretOffset));
        this.text.setText(sb.toString());
        this.text.setCaretOffset(prevWhiteSpace + proposal.getContent().length() + 1);
    }

    private int getprevWhiteSpace(String content, int caretOffset) {
        int i = caretOffset - 1;
        while (i >= 0) {
            char c = content.charAt(i);
            for (char ws : this.whiteSpace) {
                if (c != ws) continue;
                return i;
            }
            --i;
        }
        return -1;
    }
}

