/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.labelparser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.opencert.userguidance.labelparser.generated.LabelLexer;
import org.eclipse.opencert.userguidance.labelparser.generated.LabelParser;
import org.eclipse.opencert.userguidance.labelparser.tokens.HighlightItem;
import org.eclipse.opencert.userguidance.labelparser.tokens.TextToken;
import org.eclipse.opencert.userguidance.labelparser.tokens.Token;

public class LabelParserUtil {
    public static List<Token> parse(String input) {
        List<Token> result = new ArrayList<Token>();
        if (input.length() == 0) {
            return result;
        }
        ANTLRInputStream stream = new ANTLRInputStream(input);
        LabelLexer lexer = new LabelLexer((CharStream)stream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        LabelParser parser = new LabelParser((TokenStream)tokens);
        LabelParser.TextContext tree = null;
        try {
            tree = parser.text();
        }
        catch (RecognitionException recognitionException) {
            return result;
        }
        result = LabelParserUtil.process(tree);
        return result;
    }

    private static List<Token> process(LabelParser.TextContext tree) {
        ArrayList<Token> result = new ArrayList<Token>();
        int position = 0;
        int i = 0;
        while (i < tree.getChildCount()) {
            block11: {
                ParseTree child;
                block10: {
                    child = tree.getChild(i);
                    if (!(child instanceof LabelParser.ItemContext)) break block10;
                    LabelParser.ItemContext itemContext = (LabelParser.ItemContext)child;
                    if (itemContext.getChildCount() != 3) {
                        throw new IllegalArgumentException("Parser error: The token '" + itemContext.getText() + "' should have 3 child tokens.");
                    }
                    String rawItemString = null;
                    String body = null;
                    String representation = null;
                    HighlightItem.ItemHeaderType headerType = null;
                    HighlightItem.ItemBodyType bodyType = null;
                    int startIndex = -1;
                    rawItemString = itemContext.getText();
                    startIndex = itemContext.getStart().getStartIndex();
                    TerminalNode headerTerminalNode = (TerminalNode)itemContext.getChild(0);
                    String headerString = headerTerminalNode.getText();
                    headerType = HighlightItem.ItemHeaderType.parse(headerString);
                    LabelParser.ItembodyContext bodyNode = (LabelParser.ItembodyContext)itemContext.getChild(2);
                    int bodyChildCount = bodyNode.getChildCount();
                    if (bodyChildCount == 0) break block11;
                    bodyType = bodyNode.getChild(0).getText().equals("\"") && bodyNode.getChild(bodyChildCount - 1).getText().equals("\"") ? HighlightItem.ItemBodyType.doublequoted : (bodyNode.getChild(0).getText().equals("'") && bodyNode.getChild(bodyChildCount - 1).getText().equals("'") ? HighlightItem.ItemBodyType.singlequoted : HighlightItem.ItemBodyType.unquoted);
                    StringBuilder bodyBuilder = new StringBuilder();
                    int firstString = bodyType == HighlightItem.ItemBodyType.unquoted ? 0 : 1;
                    int lastString = bodyType == HighlightItem.ItemBodyType.unquoted ? bodyNode.getChildCount() : bodyNode.getChildCount() - 1;
                    int j = firstString;
                    while (j < lastString) {
                        if (!bodyNode.getChild(j).getText().startsWith("<missing ")) {
                            bodyBuilder.append(bodyNode.getChild(j).getText());
                        }
                        ++j;
                    }
                    String bodyRawText = bodyBuilder.toString();
                    if (bodyRawText.contains("|")) {
                        int pipeIndex = bodyRawText.indexOf(124);
                        body = bodyRawText.substring(0, pipeIndex);
                        representation = bodyRawText.substring(pipeIndex + 1);
                    } else {
                        body = bodyRawText;
                        representation = bodyRawText;
                    }
                    HighlightItem item = new HighlightItem(rawItemString, body, representation, headerType, bodyType, startIndex);
                    result.add(item);
                    position += item.getStartIndex() + item.getRawString().length();
                }
                if (child instanceof TerminalNode) {
                    TerminalNode terminalNode = (TerminalNode)child;
                    String text = terminalNode.getText();
                    TextToken textToken = new TextToken(text, position);
                    result.add(textToken);
                    position += textToken.getRepresentation().length();
                }
            }
            ++i;
        }
        return result;
    }
}

