/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CSSFactory;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ColorTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.IdentifierTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.NumberTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.StringTok;
import org.eclipse.swt.graphics.Color;

public class GMFToCSSConverter {
    public static final GMFToCSSConverter instance = new GMFToCSSConverter();

    private GMFToCSSConverter() {
    }

    public List<CssTok> convert(Color color) {
        ColorTok hexColor = this.getColor(color);
        return this.getExpression(new CssTok[]{hexColor});
    }

    private ColorTok getColor(Color color) {
        ColorTok hexColor = CSSFactory.eINSTANCE.createColorTok();
        String hexString = String.valueOf(this.twoDigitsHexString(color.getRed())) + this.twoDigitsHexString(color.getGreen()) + this.twoDigitsHexString(color.getBlue());
        hexColor.setValue("#" + hexString.toUpperCase());
        return hexColor;
    }

    private ColorTok getColor(int color) {
        Color swtColor = FigureUtilities.integerToColor((Integer)color);
        ColorTok result = this.getColor(swtColor);
        swtColor.dispose();
        return result;
    }

    private String twoDigitsHexString(int color) {
        String hexString = Integer.toHexString(color);
        if (hexString.length() < 2) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    public List<CssTok> convert(GradientData gradient) {
        if (gradient == null) {
            IdentifierTok noGradient = CSSFactory.eINSTANCE.createIdentifierTok();
            noGradient.setName("none");
            return this.getExpression(new CssTok[]{noGradient});
        }
        ColorTok gradientColor = this.getColor(gradient.getGradientColor1());
        IdentifierTok gradientStyle = CSSFactory.eINSTANCE.createIdentifierTok();
        int style = gradient.getGradientStyle();
        if (style == 1) {
            gradientStyle.setName("horizontal");
        } else {
            gradientStyle.setName("vertical");
        }
        return this.getExpression(new CssTok[]{gradientColor, gradientStyle});
    }

    public List<CssTok> convert(String string) {
        StringTok stringValue = CSSFactory.eINSTANCE.createStringTok();
        stringValue.setValue("\"" + string + "\"");
        return this.getExpression(new CssTok[]{stringValue});
    }

    public List<CssTok> convert(Integer intValue) {
        NumberTok numberValue = CSSFactory.eINSTANCE.createNumberTok();
        numberValue.setVal((double)intValue.intValue());
        return this.getExpression(new CssTok[]{numberValue});
    }

    public List<CssTok> convert(Enumerator enumerated) {
        IdentifierTok literalValue = CSSFactory.eINSTANCE.createIdentifierTok();
        literalValue.setName(enumerated.getName());
        return this.getExpression(new CssTok[]{literalValue});
    }

    private List<CssTok> getExpression(CssTok ... values) {
        LinkedList<CssTok> result = new LinkedList<CssTok>();
        CssTok[] cssTokArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            CssTok value = cssTokArray[n2];
            if (!result.isEmpty()) {
                result.add((CssTok)CSSFactory.eINSTANCE.createWSTok());
            }
            result.add(value);
            ++n2;
        }
        return result;
    }

    public List<CssTok> convert(boolean booleanValue) {
        IdentifierTok nameValue = CSSFactory.eINSTANCE.createIdentifierTok();
        nameValue.setName(booleanValue ? "true" : "false");
        return this.getExpression(new CssTok[]{nameValue});
    }
}

