/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.net4j.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiMap<K, V>
implements Map<K, V> {
    private transient Entries entries;
    private transient Set<K> keys;
    private transient Collection<V> values;

    public abstract int getDelegateCount();

    public Map<K, V> getDelegate(int index) {
        if (index >= 0 && index < this.getDelegateCount()) {
            return this.doGetDelegate(index);
        }
        return null;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(key, this.getDelegateCount());
    }

    @Override
    public boolean containsValue(Object value) {
        int i = 0;
        while (i < this.getDelegateCount()) {
            Map<K, V> delegate = this.getDelegate(i);
            if (delegate != null && delegate.containsValue(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        int i = 0;
        while (i < this.getDelegateCount()) {
            Map<K, V> delegate = this.getDelegate(i);
            if (delegate != null && delegate.containsKey(key)) {
                return delegate.get(key);
            }
            ++i;
        }
        return null;
    }

    @Override
    public int size() {
        int size = 0;
        Map<K, V> delegate = this.getDelegate(0);
        if (delegate != null) {
            size += delegate.size();
            int i = 1;
            while (i < this.getDelegateCount()) {
                delegate = this.getDelegate(i);
                if (delegate != null) {
                    Set<K> keySet = delegate.keySet();
                    for (K key : keySet) {
                        if (this.containsKey(key, i)) continue;
                        ++size;
                    }
                }
                ++i;
            }
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        int i = 0;
        while (i < this.getDelegateCount()) {
            Map<K, V> delegate = this.getDelegate(i);
            if (delegate != null && !delegate.isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new Entries();
        }
        return this.entries;
    }

    @Override
    public synchronized Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new Keys();
        }
        return this.keys;
    }

    @Override
    public synchronized Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    protected boolean containsKey(Object key, int delegateCount) {
        int i = 0;
        while (i < delegateCount) {
            Map<K, V> delegate = this.getDelegate(i);
            if (delegate != null && delegate.containsKey(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract Map<K, V> doGetDelegate(int var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Entries
    extends AbstractSet<Map.Entry<K, V>> {
        @Override
        public boolean add(Map.Entry<K, V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                int i = 0;
                while (i < MultiMap.this.getDelegateCount()) {
                    Object key;
                    Map delegate = MultiMap.this.getDelegate(i);
                    if (delegate != null && delegate.containsKey(key = ((Map.Entry)o).getKey())) {
                        Object value = ((Map.Entry)o).getValue();
                        if (ObjectUtil.equals(delegate.get(key), value)) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return MultiMap.this.isEmpty();
        }

        @Override
        public int size() {
            return MultiMap.this.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private Map.Entry<K, V> next;
                private int delegateIndex = -1;
                private Iterator<Map.Entry<K, V>> delegateIt;

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    this.next = null;
                    while (this.next == null) {
                        if (this.delegateIt == null) {
                            Map delegate = MultiMap.this.getDelegate(++this.delegateIndex);
                            if (delegate == null) break;
                            this.delegateIt = delegate.entrySet().iterator();
                        }
                        if (this.delegateIt.hasNext()) {
                            this.next = this.delegateIt.next();
                            if (!MultiMap.this.containsKey(this.next.getKey(), this.delegateIndex)) continue;
                            this.next = null;
                            continue;
                        }
                        this.delegateIt = null;
                    }
                    return this.next != null;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    try {
                        Map.Entry entry = this.next;
                        return entry;
                    }
                    finally {
                        this.next = null;
                    }
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Keys
    extends AbstractSet<K> {
        @Override
        public boolean add(K o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return MultiMap.this.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return MultiMap.this.isEmpty();
        }

        @Override
        public int size() {
            return MultiMap.this.size();
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                private K next;
                private int delegateIndex = -1;
                private Iterator<K> delegateIt;

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    this.next = null;
                    while (this.next == null) {
                        if (this.delegateIt == null) {
                            Map delegate = MultiMap.this.getDelegate(++this.delegateIndex);
                            if (delegate == null) break;
                            this.delegateIt = delegate.keySet().iterator();
                        }
                        if (this.delegateIt.hasNext()) {
                            this.next = this.delegateIt.next();
                            if (!MultiMap.this.containsKey(this.next, this.delegateIndex)) continue;
                            this.next = null;
                            continue;
                        }
                        this.delegateIt = null;
                    }
                    return this.next != null;
                }

                @Override
                public K next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    try {
                        Object k = this.next;
                        return k;
                    }
                    finally {
                        this.next = null;
                    }
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListBased<K, V>
    extends MultiMap<K, V> {
        private List<Map<K, V>> delegates;

        public ListBased() {
        }

        public ListBased(List<Map<K, V>> delegates) {
            this.delegates = delegates;
        }

        public synchronized List<Map<K, V>> getDelegates() {
            if (this.delegates == null) {
                this.delegates = this.createDelegates();
            }
            return this.delegates;
        }

        public void setDelegates(List<Map<K, V>> delegates) {
            this.delegates = delegates;
        }

        @Override
        public int getDelegateCount() {
            return this.getDelegates().size();
        }

        @Override
        protected Map<K, V> doGetDelegate(int index) {
            return this.getDelegates().get(index);
        }

        protected List<Map<K, V>> createDelegates() {
            return new ArrayList<Map<K, V>>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Values
    extends AbstractCollection<V> {
        @Override
        public boolean add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return MultiMap.this.containsValue(o);
        }

        @Override
        public boolean isEmpty() {
            return MultiMap.this.isEmpty();
        }

        @Override
        public int size() {
            return MultiMap.this.size();
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                private Iterator<Map.Entry<K, V>> delegateIt;
                {
                    this.delegateIt = MultiMap.this.entrySet().iterator();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return this.delegateIt.hasNext();
                }

                @Override
                public V next() {
                    return this.delegateIt.next().getValue();
                }
            };
        }
    }
}

