/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.resource.IResourceUIServiceProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class GlobalURIEditorOpener
implements IURIEditorOpener {
    private static final Logger logger = Logger.getLogger(GlobalURIEditorOpener.class);
    @Inject
    private IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    private IStorage2UriMapper mapper;
    @Inject(optional=true)
    private IWorkbench workbench;

    public IEditorPart open(URI uri, Object context, boolean select) {
        return this.open(uri, select);
    }

    @Override
    public IEditorPart open(URI uri, boolean select) {
        IURIEditorOpener editorOpener;
        IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(uri.trimFragment());
        if (resourceServiceProvider instanceof IResourceUIServiceProvider && (editorOpener = ((IResourceUIServiceProvider)resourceServiceProvider).getURIEditorOpener()) != null) {
            return editorOpener.open(uri, select);
        }
        return this.openDefaultEditor(uri, null, -1, select);
    }

    @Override
    public IEditorPart open(URI referenceOwnerURI, EReference reference, int indexInList, boolean select) {
        IURIEditorOpener editorOpener;
        IResourceServiceProvider resourceServiceProvider = this.resourceServiceProviderRegistry.getResourceServiceProvider(referenceOwnerURI.trimFragment());
        if (resourceServiceProvider instanceof IResourceUIServiceProvider && (editorOpener = ((IResourceUIServiceProvider)resourceServiceProvider).getURIEditorOpener()) != null) {
            return editorOpener.open(referenceOwnerURI, reference, indexInList, select);
        }
        return this.openDefaultEditor(referenceOwnerURI, reference, indexInList, select);
    }

    protected IEditorPart openDefaultEditor(URI uri, EReference crossReference, int indexInList, boolean select) {
        Iterator<Pair<IStorage, IProject>> storages = this.mapper.getStorages(uri.trimFragment()).iterator();
        if (storages != null && storages.hasNext()) {
            try {
                IStorage storage = (IStorage)storages.next().getFirst();
                IEditorPart editor = null;
                editor = storage instanceof IFile ? this.openDefaultEditor((IFile)storage) : this.openDefaultEditor(storage, uri);
                this.selectAndReveal(editor, uri, crossReference, indexInList, select);
                return editor;
            }
            catch (WrappedException e) {
                logger.error((Object)("Error while opening editor part for EMF URI '" + uri + "'"), e.getCause());
            }
            catch (PartInitException partInitException) {
                logger.error((Object)("Error while opening editor part for EMF URI '" + uri + "'"), (Throwable)partInitException);
            }
        }
        return null;
    }

    protected void selectAndReveal(IEditorPart openEditor, final URI uri, final EReference crossReference, final int indexInList, final boolean select) {
        final XtextEditor xtextEditor = EditorUtils.getXtextEditor(openEditor);
        if (xtextEditor != null && uri.fragment() != null) {
            xtextEditor.getDocument().priorityReadOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                public void process(XtextResource resource) throws Exception {
                    if (resource != null) {
                        ITextRegion location;
                        EObject object = resource.getEObject(uri.fragment());
                        ILocationInFileProvider locationProvider = (ILocationInFileProvider)resource.getResourceServiceProvider().get(ILocationInFileProvider.class);
                        ITextRegion iTextRegion = location = crossReference != null ? locationProvider.getSignificantTextRegion(object, (EStructuralFeature)crossReference, indexInList) : locationProvider.getSignificantTextRegion(object);
                        if (select) {
                            xtextEditor.selectAndReveal(location.getOffset(), location.getLength());
                        } else {
                            xtextEditor.reveal(location.getOffset(), location.getLength());
                        }
                    }
                }
            });
        }
    }

    protected IEditorPart openDefaultEditor(IFile file) throws PartInitException {
        IWorkbenchPage page = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return IDE.openEditor((IWorkbenchPage)page, (IFile)file);
    }

    protected IEditorPart openDefaultEditor(IStorage storage, URI uri) throws PartInitException {
        IEditorInput editorInput = EditorUtils.createEditorInput(storage);
        IWorkbenchPage page = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(uri.lastSegment()).getId());
    }

    protected IWorkbench getWorkbench() {
        if (this.workbench == null) {
            throw new IllegalStateException("No workbench");
        }
        return this.workbench;
    }
}

