/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.ui.extension.commands.IModelCreationCommand;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;

public abstract class ModelCreationCommandBase
implements IModelCreationCommand {
    public void createModel(ModelSet modelSet) {
        this.runAsTransaction(modelSet);
    }

    protected void runAsTransaction(ModelSet modelSet) {
        final Resource modelResource = UmlUtils.getUmlResource((ModelSet)modelSet);
        TransactionalEditingDomain editingDomain = modelSet.getTransactionalEditingDomain();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Initialize model", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EObject model = ModelCreationCommandBase.this.getRootElement(modelResource);
                ModelCreationCommandBase.this.attachModelToResource(model, modelResource);
                ModelCreationCommandBase.this.initializeModel(model);
                return CommandResult.newOKCommandResult();
            }
        };
        editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
    }

    protected void initializeModel(EObject owner) {
    }

    protected EObject getRootElement(Resource modelResource) {
        EObject rootElement = null;
        if (modelResource != null && modelResource.getContents() != null && modelResource.getContents().size() > 0) {
            Object root = modelResource.getContents().get(0);
            if (root instanceof EObject) {
                rootElement = (EObject)root;
            }
        } else {
            rootElement = this.createRootElement();
        }
        return rootElement;
    }

    protected void attachModelToResource(EObject root, Resource resource) {
        resource.getContents().add((Object)root);
    }

    protected abstract EObject createRootElement();
}

