/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.ui.IEditorPart;

public class XMLPaletteProviderConfiguration
extends AbstractProviderConfiguration {
    private EditorDescriptor editor;
    private String name;
    private String id;
    private ProviderPriority priority = ProviderPriority.LOWEST;
    protected boolean displayEntries = false;

    protected XMLPaletteProviderConfiguration(IConfigurationElement configElement) {
        IConfigurationElement[] configChildren = configElement.getChildren("editor");
        if (configChildren.length > 0) {
            this.editor = new EditorDescriptor(configChildren[0]);
        }
        this.name = configElement.getDeclaringExtension().getLabel();
        if (this.name == null || this.name.equals("")) {
            this.name = configElement.getDeclaringExtension().getContributor().getName();
        }
        if (this.name == null || this.name.equals("")) {
            this.name = "<Unnamed>";
        } else if (this.name.equals("%ext.presentationPaletteProvider")) {
            this.name = "Presentation Palette";
        } else if (this.name.equals("org.eclipse.gmf.runtime.diagram.ui.geoshapes")) {
            this.name = "Geoshapes";
        }
        this.id = configElement.getDeclaringExtension().getUniqueIdentifier();
        if (this.id == null || this.id.equals("")) {
            this.id = configElement.getDeclaringExtension().getContributor().getName();
        }
        if ((configChildren = configElement.getChildren("priority")).length > 0) {
            configChildren = configElement.getChildren("Priority");
        }
        if (configChildren.length > 0) {
            this.priority = ProviderPriority.parse((String)configChildren[0].getAttribute("name"));
        }
    }

    public String getName() {
        return this.name;
    }

    public EditorDescriptor getEditor() {
        return this.editor;
    }

    public String getID() {
        return this.id;
    }

    public static XMLPaletteProviderConfiguration parse(IConfigurationElement configElement) {
        Assert.isNotNull((Object)configElement, (String)"null provider configuration element");
        return new XMLPaletteProviderConfiguration(configElement);
    }

    public boolean supports(IEditorPart targetEditor, Object targetContent) {
        return this.editor == null || this.editor.sameAs(targetEditor);
    }

    public boolean hasOnlyEntriesDefinition() {
        return !this.displayEntries;
    }

    public ProviderPriority getPriority() {
        return this.priority;
    }

    protected static class EditorDescriptor
    extends AbstractProviderConfiguration.ObjectDescriptor {
        private final String targetId;

        public EditorDescriptor(IConfigurationElement configElement) {
            super(configElement);
            this.targetId = configElement.getAttribute("id");
        }

        public String getTargetId() {
            return this.targetId;
        }

        public boolean sameAs(Object object) {
            if (!(object instanceof DiagramEditorWithFlyOutPalette)) {
                return false;
            }
            if (this.targetId != null && !this.targetId.equals(((DiagramEditorWithFlyOutPalette)object).getContributorId())) {
                return false;
            }
            return super.sameAs(object);
        }
    }
}

