/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CustomLifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineDotLineCustomFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.HighlightUtil;

public class CustomCombinedFragment2ResizeEditPolicy
extends ResizableShapeEditPolicy {
    public CustomCombinedFragment2ResizeEditPolicy() {
        this.setResizeDirections(5);
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        CustomLifelineEditPart lifelineEP = (CustomLifelineEditPart)this.getHost().getParent();
        request.getMoveDelta().x = 0;
        request.getSizeDelta().width = 0;
        IFigure feedback = this.getDragSourceFeedbackFigure();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        IFigure f = this.getHostFigure();
        Dimension min = f.getMinimumSize().getCopy();
        Dimension max = f.getMaximumSize().getCopy();
        IMapMode mmode = MapModeUtil.getMapMode((IFigure)f);
        min.height = mmode.LPtoDP(min.height);
        min.width = mmode.LPtoDP(min.width);
        max.height = mmode.LPtoDP(max.height);
        max.width = mmode.LPtoDP(max.width);
        Rectangle originalBounds = rect.getCopy();
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        rect.width = Math.min(Math.max(rect.width, min.width), max.width);
        rect.height = Math.min(Math.max(rect.height, min.height), max.height);
        if (rect.height == min.height && request.getSizeDelta().height < 0 && request.getMoveDelta().y > 0) {
            Point loc = rect.getLocation();
            loc.y = originalBounds.getBottom().y - min.height;
            rect.setLocation(loc);
            request.getSizeDelta().height = min.height - originalBounds.height;
            request.getMoveDelta().y = loc.y - originalBounds.y;
        }
        if (rect.height == min.height && request.getSizeDelta().height < 0 && request.getMoveDelta().y == 0) {
            request.getSizeDelta().height = min.height - originalBounds.height;
        }
        LifelineDotLineCustomFigure dotlineFigure = lifelineEP.getPrimaryShape().getFigureLifelineDotLineFigure();
        Rectangle rectParent = dotlineFigure.getBounds().getCopy();
        lifelineEP.getPrimaryShape().translateToAbsolute((Translatable)rectParent);
        int minLifelineY = rectParent.y + 5;
        if (rect.y < minLifelineY) {
            request.getMoveDelta().y += minLifelineY - rect.y;
            rect.y = minLifelineY;
        }
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.eraseChangeBoundsFeedback(request);
        HighlightUtil.unhighlight();
    }
}

