/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.ui;

import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.io.IOUtil;

public interface ISecurityManagementContext {
    public static final ISecurityManagementContext DEFAULT = new Default();

    public CDOView connect(CDOSession var1);

    public void disconnect(CDOView var1);

    public CDOResource getSecurityResource(CDOView var1);

    public static class Default
    implements ISecurityManagementContext {
        public CDOView connect(CDOSession session) {
            if (session.isClosed()) {
                return null;
            }
            if ("Administrator".equals(session.getUserID())) {
                return session.openTransaction();
            }
            return session.openView();
        }

        public void disconnect(CDOView view) {
            view.close();
        }

        public CDOResource getSecurityResource(CDOView view) {
            CDOResource result;
            block9: {
                result = null;
                try {
                    result = view.getResource("/security");
                }
                catch (Exception e) {
                    CloseableIterator realms = null;
                    try {
                        try {
                            realms = view.queryInstancesAsync(SecurityPackage.Literals.REALM);
                            if (realms.hasNext()) {
                                result = (CDOResource)((EObject)realms.next()).eResource();
                            }
                        }
                        catch (Exception e2) {
                            OM.LOG.error((Throwable)e2);
                            IOUtil.closeSilent((Closeable)realms);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.closeSilent(realms);
                        throw throwable;
                    }
                    IOUtil.closeSilent((Closeable)realms);
                }
            }
            if (result == null) {
                OM.LOG.warn("Security model resource not available.");
            }
            return result;
        }
    }
}

