/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.evaluator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.core.OCLDebugCore;
import org.eclipse.ocl.examples.debug.evaluator.OCLVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMExecutor;
import org.eclipse.ocl.examples.debug.vm.evaluator.VMRootEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceBuilder;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class OCLVMRootEvaluationEnvironment
extends VMRootEvaluationEnvironment
implements OCLVMEvaluationEnvironment {
    private List<Runnable> myDeferredTasks;
    private boolean myIsDeferedExecution;
    private @NonNull Element myCurrentIP;
    private @NonNull NamedElement myOperation;
    private final long id;
    private final @NonNull Variable pcVariable;

    public OCLVMRootEvaluationEnvironment(@NonNull VMExecutor vmExecutor, @NonNull ExpressionInOCL executableObject, long id) {
        super(vmExecutor, (NamedElement)executableObject);
        this.myCurrentIP = executableObject;
        this.myOperation = executableObject;
        this.id = id;
        this.pcVariable = (Variable)ClassUtil.nonNullEMF((Object)PivotFactory.eINSTANCE.createVariable());
        this.pcVariable.setName("$pc");
        String typeName = (String)ClassUtil.nonNullEMF((Object)PivotPackage.Literals.OCL_EXPRESSION.getName());
        this.pcVariable.setType((Type)this.environmentFactory.getMetamodelManager().getASClass(typeName));
    }

    @Override
    public @NonNull OCLVMEvaluationEnvironment createClonedEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    public @NonNull Element getCurrentIP() {
        return this.myCurrentIP;
    }

    public @NonNull UnitLocation getCurrentLocation() {
        int startPosition = ASTBindingHelper.getStartPosition((Element)this.myCurrentIP);
        int endPosition = ASTBindingHelper.getEndPosition((Element)this.myCurrentIP);
        return new UnitLocation(startPosition, endPosition, (VMEvaluationEnvironment)this, this.myCurrentIP);
    }

    public @NonNull OCLDebugCore getDebugCore() {
        return OCLDebugCore.INSTANCE;
    }

    public int getDepth() {
        return 1;
    }

    public long getID() {
        return this.id;
    }

    public @NonNull NamedElement getOperation() {
        return this.myOperation;
    }

    @Override
    public @Nullable OCLVMRootEvaluationEnvironment getVMParentEvaluationEnvironment() {
        return (OCLVMRootEvaluationEnvironment)super.getVMParentEvaluationEnvironment();
    }

    public @NonNull Variable getPCVariable() {
        return this.pcVariable;
    }

    @Override
    public @NonNull OCLVMRootEvaluationEnvironment getVMRootEvaluationEnvironment() {
        return this;
    }

    public boolean isDeferredExecution() {
        return this.myIsDeferedExecution;
    }

    public void processDeferredTasks() {
        if (this.myDeferredTasks != null) {
            try {
                this.myIsDeferedExecution = true;
                ArrayList<Runnable> tasksCopy = new ArrayList<Runnable>(this.myDeferredTasks);
                for (Runnable task : tasksCopy) {
                    task.run();
                }
            }
            finally {
                this.myIsDeferedExecution = false;
            }
        }
    }

    protected void saveThrownException(@NonNull VMRuntimeException exception) {
    }

    public @NonNull Element setCurrentIP(@NonNull Element element) {
        Element prevValue = this.myCurrentIP;
        this.myCurrentIP = element;
        return prevValue;
    }

    public void setException(@NonNull VMRuntimeException exception) {
        this.saveThrownException(exception);
    }

    public void throwVMException(@NonNull VMRuntimeException exception) throws VMRuntimeException {
        try {
            this.saveThrownException(exception);
            exception.setStackVMTrace(new VMStackTraceBuilder((VMEvaluationEnvironment)this).buildStackTrace());
        }
        catch (Exception e) {
            this.getDebugCore().error("Failed to build VM stack trace", e);
        }
        throw exception;
    }
}

