/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.SourceRangeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;

public class RefactoringAnalyzeUtil {
    private RefactoringAnalyzeUtil() {
    }

    public static IRegion[] getNewRanges(TextEdit[] edits, TextChange change) {
        IRegion[] result = new IRegion[edits.length];
        int i = 0;
        while (i < edits.length) {
            result[i] = RefactoringAnalyzeUtil.getNewTextRange(edits[i], change);
            ++i;
        }
        return result;
    }

    public static RefactoringStatus reportProblemNodes(String modifiedWorkingCopySource, SimpleName[] problemNodes) {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < problemNodes.length) {
            JavaStringStatusContext context = new JavaStringStatusContext(modifiedWorkingCopySource, SourceRangeFactory.create((ASTNode)problemNodes[i]));
            result.addError(Messages.format(RefactoringCoreMessages.RefactoringAnalyzeUtil_name_collision, BasicElementLabels.getJavaElementName(problemNodes[i].getIdentifier())), (RefactoringStatusContext)context);
            ++i;
        }
        return result;
    }

    public static LambdaExpression getLambdaExpression(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        return (LambdaExpression)ASTNodes.getParent((ASTNode)decl, LambdaExpression.class);
    }

    public static MethodDeclaration getMethodDeclaration(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        return (MethodDeclaration)ASTNodes.getParent((ASTNode)decl, MethodDeclaration.class);
    }

    public static Block getBlock(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        return (Block)ASTNodes.getParent((ASTNode)decl, Block.class);
    }

    public static IProblem[] getIntroducedCompileProblems(CompilationUnit newCUNode, CompilationUnit oldCuNode) {
        HashSet<IProblem> subResult = new HashSet<IProblem>();
        Set<IProblem> oldProblems = RefactoringAnalyzeUtil.getOldProblems(oldCuNode);
        IProblem[] newProblems = ASTNodes.getProblems((ASTNode)newCUNode, 2, 7);
        int i = 0;
        while (i < newProblems.length) {
            IProblem correspondingOld = RefactoringAnalyzeUtil.findCorrespondingProblem(oldProblems, newProblems[i]);
            if (correspondingOld == null) {
                subResult.add(newProblems[i]);
            }
            ++i;
        }
        return subResult.toArray(new IProblem[subResult.size()]);
    }

    public static IRegion getNewTextRange(TextEdit edit, TextChange change) {
        return change.getPreviewEdit(edit).getRegion();
    }

    private static IProblem findCorrespondingProblem(Set<IProblem> oldProblems, IProblem iProblem) {
        for (IProblem oldProblem : oldProblems) {
            if (!RefactoringAnalyzeUtil.isCorresponding(oldProblem, iProblem)) continue;
            return oldProblem;
        }
        return null;
    }

    private static boolean isCorresponding(IProblem oldProblem, IProblem iProblem) {
        if (oldProblem.getID() != iProblem.getID()) {
            return false;
        }
        return oldProblem.getMessage().equals(iProblem.getMessage());
    }

    private static SimpleName getSimpleName(ASTNode node) {
        if (node instanceof SimpleName) {
            return (SimpleName)node;
        }
        if (node instanceof VariableDeclaration) {
            return ((VariableDeclaration)node).getName();
        }
        return null;
    }

    private static SimpleName findSimpleNameNode(IRegion range, CompilationUnit cuNode) {
        ASTNode node = NodeFinder.perform((ASTNode)cuNode, (int)range.getOffset(), (int)range.getLength());
        return RefactoringAnalyzeUtil.getSimpleName(node);
    }

    private static Set<IProblem> getOldProblems(CompilationUnit oldCuNode) {
        return new HashSet<IProblem>(Arrays.asList(ASTNodes.getProblems((ASTNode)oldCuNode, 2, 7)));
    }
}

