/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralChangeEventHelper;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiRowReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderEndCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderStartCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.config.DefaultRowReorderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.reorder.event.RowReorderEvent;

public class RowReorderLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private static final Log log = LogFactory.getLog(RowReorderLayer.class);
    public static final String PERSISTENCE_KEY_ROW_INDEX_ORDER = ".rowIndexOrder";
    private final IUniqueIndexLayer underlyingLayer;
    protected final List<Integer> rowIndexOrder = new ArrayList<Integer>();
    private final Map<Integer, Integer> startYCache = new HashMap<Integer, Integer>();
    private int reorderFromRowPosition;

    public RowReorderLayer(IUniqueIndexLayer underlyingLayer) {
        this(underlyingLayer, true);
    }

    public RowReorderLayer(IUniqueIndexLayer underlyingLayer, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.underlyingLayer = underlyingLayer;
        this.populateIndexOrder();
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultRowReorderLayerConfiguration());
        }
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        IStructuralChangeEvent structuralChangeEvent;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isVerticalStructureChanged()) {
            Collection<StructuralDiff> structuralDiffs = structuralChangeEvent.getRowDiffs();
            if (structuralDiffs == null) {
                this.rowIndexOrder.clear();
                this.populateIndexOrder();
            } else {
                StructuralChangeEventHelper.handleRowDelete(structuralDiffs, this.underlyingLayer, this.rowIndexOrder, true);
                StructuralChangeEventHelper.handleRowInsert(structuralDiffs, this.underlyingLayer, this.rowIndexOrder, true);
            }
            this.invalidateCache();
        }
        super.handleLayerEvent(event);
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new RowReorderCommandHandler(this));
        this.registerCommandHandler(new RowReorderStartCommandHandler(this));
        this.registerCommandHandler(new RowReorderEndCommandHandler(this));
        this.registerCommandHandler(new MultiRowReorderCommandHandler(this));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        if (this.rowIndexOrder.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Integer index : this.rowIndexOrder) {
                strBuilder.append(index);
                strBuilder.append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_INDEX_ORDER, strBuilder.toString());
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_INDEX_ORDER);
        if (property != null) {
            ArrayList<Integer> newRowIndexOrder = new ArrayList<Integer>();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                newRowIndexOrder.add(Integer.valueOf(index));
            }
            if (this.isRestoredStateValid(newRowIndexOrder)) {
                this.rowIndexOrder.clear();
                this.rowIndexOrder.addAll(newRowIndexOrder);
            }
        }
        this.invalidateCache();
        this.fireLayerEvent(new RowStructuralRefreshEvent(this));
    }

    protected boolean isRestoredStateValid(List<Integer> newRowIndexOrder) {
        if (newRowIndexOrder.size() != this.getRowCount()) {
            log.error((Object)("Number of persisted rows (" + newRowIndexOrder.size() + ") " + "is not the same as the number of rows in the data source (" + this.getRowCount() + ").\n" + "Skipping restore of row ordering"));
            return false;
        }
        for (Integer index : newRowIndexOrder) {
            if (this.rowIndexOrder.contains(index)) continue;
            log.error((Object)("Row index: " + index + " being restored, is not a available in the data soure.\n" + "Skipping restore of row ordering"));
            return false;
        }
        return true;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.underlyingLayer.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowPositionByY(int y) {
        return LayerUtil.getRowPositionByY(this, y);
    }

    @Override
    public int getStartYOfRowPosition(int targetRowPosition) {
        Integer cachedStartY = this.startYCache.get(targetRowPosition);
        if (cachedStartY != null) {
            return cachedStartY;
        }
        int aggregateWidth = 0;
        int rowPosition = 0;
        while (rowPosition < targetRowPosition) {
            aggregateWidth += this.underlyingLayer.getRowHeightByPosition(this.localToUnderlyingRowPosition(rowPosition));
            ++rowPosition;
        }
        this.startYCache.put(targetRowPosition, aggregateWidth);
        return aggregateWidth;
    }

    private void populateIndexOrder() {
        ILayer underlyingLayer = this.getUnderlyingLayer();
        int rowPosition = 0;
        while (rowPosition < underlyingLayer.getRowCount()) {
            this.rowIndexOrder.add(underlyingLayer.getRowIndexByPosition(rowPosition));
            ++rowPosition;
        }
    }

    public List<Integer> getRowIndexOrder() {
        return this.rowIndexOrder;
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition >= 0 && rowPosition < this.rowIndexOrder.size()) {
            return this.rowIndexOrder.get(rowPosition);
        }
        return -1;
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.rowIndexOrder.indexOf(rowIndex);
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        int rowIndex = this.getRowIndexByPosition(localRowPosition);
        return this.underlyingLayer.getRowPositionByIndex(rowIndex);
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        int rowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingRowPosition);
        return this.getRowPositionByIndex(rowIndex);
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        ArrayList<Integer> reorderedRowPositions = new ArrayList<Integer>();
        for (Range underlyingRowPositionRange : underlyingRowPositionRanges) {
            int underlyingRowPosition = underlyingRowPositionRange.start;
            while (underlyingRowPosition < underlyingRowPositionRange.end) {
                int localRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, underlyingRowPositionRange.start);
                reorderedRowPositions.add(localRowPosition);
                ++underlyingRowPosition;
            }
        }
        Collections.sort(reorderedRowPositions);
        return PositionUtil.getRanges(reorderedRowPositions);
    }

    private void moveRow(int fromRowPosition, int toRowPosition, boolean reorderToTopEdge) {
        if (!reorderToTopEdge) {
            ++toRowPosition;
        }
        Integer fromRowIndex = this.rowIndexOrder.get(fromRowPosition);
        this.rowIndexOrder.add(toRowPosition, fromRowIndex);
        this.rowIndexOrder.remove(fromRowPosition + (fromRowPosition > toRowPosition ? 1 : 0));
        this.invalidateCache();
    }

    public void reorderRowPosition(int fromRowPosition, int toRowPosition) {
        boolean reorderToTopEdge;
        if (toRowPosition < this.getRowCount()) {
            reorderToTopEdge = true;
        } else {
            reorderToTopEdge = false;
            --toRowPosition;
        }
        this.reorderRowPosition(fromRowPosition, toRowPosition, reorderToTopEdge);
    }

    public void reorderRowPosition(int fromRowPosition, int toRowPosition, boolean reorderToTopEdge) {
        this.moveRow(fromRowPosition, toRowPosition, reorderToTopEdge);
        this.fireLayerEvent(new RowReorderEvent((ILayer)this, fromRowPosition, toRowPosition, reorderToTopEdge));
    }

    public void reorderMultipleRowPositions(List<Integer> fromRowPositions, int toRowPosition) {
        boolean reorderToTopEdge;
        if (toRowPosition < this.getRowCount()) {
            reorderToTopEdge = true;
        } else {
            reorderToTopEdge = false;
            --toRowPosition;
        }
        this.reorderMultipleRowPositions(fromRowPositions, toRowPosition, reorderToTopEdge);
    }

    public void reorderMultipleRowPositions(List<Integer> fromRowPositions, int toRowPosition, boolean reorderToTopEdge) {
        int fromRowPositionsCount = fromRowPositions.size();
        if (toRowPosition > fromRowPositions.get(fromRowPositionsCount - 1)) {
            int firstRowPosition = fromRowPositions.get(0);
            int rowCount = 0;
            while (rowCount < fromRowPositionsCount) {
                int fromRowPosition = fromRowPositions.get(0);
                this.moveRow(fromRowPosition, toRowPosition, reorderToTopEdge);
                if (fromRowPosition < firstRowPosition) {
                    firstRowPosition = fromRowPosition;
                }
                ++rowCount;
            }
        } else if (toRowPosition < fromRowPositions.get(fromRowPositionsCount - 1)) {
            int targetRowPosition = toRowPosition;
            for (Integer fromRowPosition : fromRowPositions) {
                int fromRowPositionInt = fromRowPosition;
                this.moveRow(fromRowPositionInt, targetRowPosition++, reorderToTopEdge);
            }
        }
        this.fireLayerEvent(new RowReorderEvent((ILayer)this, fromRowPositions, toRowPosition, reorderToTopEdge));
    }

    private void invalidateCache() {
        this.startYCache.clear();
    }

    public int getReorderFromRowPosition() {
        return this.reorderFromRowPosition;
    }

    public void setReorderFromRowPosition(int fromRowPosition) {
        this.reorderFromRowPosition = fromRowPosition;
    }
}

