/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools;

import javassist.util.proxy.ProxyFactory;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;

public abstract class EntityTools {
    public static boolean entitiesEqual(SessionImplementor session, String entityName, Object obj1, Object obj2) {
        Object id1 = EntityTools.getIdentifier(session, entityName, obj1);
        Object id2 = EntityTools.getIdentifier(session, entityName, obj2);
        return Tools.objectsEqual(id1, id2);
    }

    public static Object getIdentifier(SessionImplementor session, String entityName, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)obj;
            return hibernateProxy.getHibernateLazyInitializer().getIdentifier();
        }
        return session.getEntityPersister(entityName, obj).getIdentifier(obj, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getTargetFromProxy(SessionFactoryImplementor sessionFactoryImplementor, HibernateProxy proxy) {
        if (!proxy.getHibernateLazyInitializer().isUninitialized() || EntityTools.activeProxySession(proxy)) {
            return proxy.getHibernateLazyInitializer().getImplementation();
        }
        SessionImplementor sessionImplementor = proxy.getHibernateLazyInitializer().getSession();
        Session tempSession = sessionImplementor == null ? sessionFactoryImplementor.openTemporarySession() : sessionImplementor.getFactory().openTemporarySession();
        try {
            Object object = tempSession.get(proxy.getHibernateLazyInitializer().getEntityName(), proxy.getHibernateLazyInitializer().getIdentifier());
            return object;
        }
        finally {
            tempSession.close();
        }
    }

    private static boolean activeProxySession(HibernateProxy proxy) {
        Session session = (Session)proxy.getHibernateLazyInitializer().getSession();
        return session != null && session.isOpen() && session.isConnected();
    }

    public static <T> Class<T> getTargetClassIfProxied(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        if (ProxyFactory.isProxyClass(clazz)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    public static Class getEntityClass(SessionImplementor sessionImplementor, Session session, String entityName) {
        EntityPersister entityPersister = sessionImplementor.getFactory().getEntityPersister(entityName);
        return entityPersister.getMappedClass();
    }
}

