/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.importer.importWizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.opencert.vocabulary.Vocabulary;
import org.eclipse.opencert.vocabulary.importer.importWizards.ImportWizardPage;
import org.eclipse.opencert.vocabulary.importer.parser.Parser;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class VocabularyImportWizard
extends Wizard
implements IImportWizard {
    ImportWizardPage mainPage;

    public boolean performFinish() {
        InputStream inputStream = this.mainPage.getInitialContents();
        Vocabulary vocabulary = Parser.parseVocabulary(inputStream);
        String targetFilename = String.valueOf(this.mainPage.getFileName()) + ".vocabulary";
        String containerPath = this.mainPage.getContainerFullPath().toString();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createFileURI((String)(String.valueOf(containerPath) + "/" + targetFilename));
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add((Object)vocabulary);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            IPath path = fileHandle.getFullPath();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int numSegments = path.segmentCount();
            if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                int i = numSegments - 2;
                while (i > 0) {
                    IFolder folder = root.getFolder(path.removeLastSegments(i));
                    if (!folder.exists()) {
                        folder.create(false, true, monitor);
                    }
                    --i;
                }
            }
            fileHandle.create(contents, false, monitor);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Vocabulary Import Wizard");
        this.setNeedsProgressMonitor(true);
        this.mainPage = new ImportWizardPage("Import from File", selection);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }
}

