/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.chessextension.propertytab;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.opencert.sam.arg.arg.Claim;
import org.eclipse.opencert.sam.arg.arg.impl.ClaimImpl;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.clazz.custom.edit.part.CustomConstraintEditPart;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.contracts.chessextension.propertytab.ClaimTreeContentProvider;
import org.polarsys.chess.contracts.chessextension.propertytab.ClaimTreeDropAdapter;
import org.polarsys.chess.contracts.chessextension.propertytab.Utils;
import org.polarsys.chess.contracts.profile.chesscontract.FormalProperty;
import org.polarsys.chess.service.utils.CHESSEditorUtils;

public class FormalPropertyEditPartSection
extends AbstractPropertySection {
    public static final String CONTRACT = "CHESSContract::Contract";
    public static final String CONTRACT_PROP = "CHESSContract::ContractProperty";
    public static final String FORMAL_PROP = "CHESSContract::FormalProperty";
    private Constraint constraint;
    private Button removeClaimButton;
    private ClaimTreeDropAdapter claimDropAdapter;
    private TableViewer claimViewer;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createComposite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 3;
        Label claimLabel = this.getWidgetFactory().createLabel(composite, "Claim", 0);
        claimLabel.setLayoutData((Object)gd);
        this.removeClaimButton = this.getWidgetFactory().createButton(composite, "", 0);
        ImageDescriptor remImageDes = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.chess.contracts.chessextension", (String)"/icons/rem_co.gif");
        this.removeClaimButton.setImage(remImageDes.createImage());
        this.removeClaimButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = FormalPropertyEditPartSection.this.claimViewer.getSelection();
                final Claim claim = (Claim)((StructuredSelection)selection).getFirstElement();
                PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
                if (editor != null) {
                    TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)editor.getEditingDomain();
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            Stereotype stereo = FormalPropertyEditPartSection.this.constraint.getAppliedStereotype(FormalPropertyEditPartSection.FORMAL_PROP);
                            FormalProperty formalPropStereo = (FormalProperty)FormalPropertyEditPartSection.this.constraint.getStereotypeApplication(stereo);
                            formalPropStereo.getClaim().remove((Object)claim);
                        }
                    });
                    FormalPropertyEditPartSection.this.claimViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(0x1000008, 4, false, false);
        gd.horizontalSpan = 1;
        this.removeClaimButton.setLayoutData((Object)gd);
        this.claimViewer = new TableViewer(composite, 68354);
        this.createClaimColumns(parent, this.claimViewer);
        Table tableclaim = this.claimViewer.getTable();
        tableclaim.setHeaderVisible(true);
        tableclaim.setLinesVisible(true);
        this.claimViewer.setContentProvider((IContentProvider)ClaimTreeContentProvider.getInstance());
        this.claimDropAdapter = new ClaimTreeDropAdapter(this.claimViewer);
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        int ops = 3;
        this.claimViewer.addDropSupport(ops, transfers, (DropTargetListener)this.claimDropAdapter);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 4;
        this.claimViewer.getControl().setLayoutData((Object)gd);
        this.claimViewer.addDoubleClickListener((IDoubleClickListener)new ClickListener());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            this.cleanPropertyTab();
            return;
        }
        List selectionList = ((IStructuredSelection)selection).toList();
        if (selectionList.size() == 1) {
            Object selected = selectionList.get(0);
            EObject selectedEObject = EMFHelper.getEObject(selected);
            if (selected instanceof CustomConstraintEditPart) {
                Constraint constr = (Constraint)((CustomConstraintEditPart)selected).resolveSemanticElement();
                if (constr.getAppliedStereotype(FORMAL_PROP) != null) {
                    this.cleanPropertyTab();
                    this.setContractPropertyTab(constr);
                }
            } else {
                this.cleanPropertyTab();
            }
        } else {
            this.cleanPropertyTab();
        }
        this.claimDropAdapter.setConstraint(this.constraint);
        if (this.constraint != null) {
            Stereotype stereo = this.constraint.getAppliedStereotype(FORMAL_PROP);
            FormalProperty formalPropStereo = (FormalProperty)this.constraint.getStereotypeApplication(stereo);
            this.claimViewer.setInput((Object)formalPropStereo.getClaim());
        }
    }

    private void setContractPropertyTab(Constraint constr) {
        this.constraint = constr;
        Stereotype formalProp = constr.getAppliedStereotype(FORMAL_PROP);
        FormalProperty foprmalPropStereo = (FormalProperty)this.constraint.getStereotypeApplication(formalProp);
        this.claimViewer.setInput((Object)foprmalPropStereo.getClaim());
    }

    private void cleanPropertyTab() {
        this.claimViewer.setInput(null);
    }

    private void createClaimColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"Claim", "Resource"};
        int[] bounds = new int[]{400, 200};
        TableViewerColumn col = this.createTableViewerColumn(viewer, titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Claim claim = (Claim)element;
                return String.valueOf(claim.getId()) + " " + claim.getName();
            }
        });
        col = this.createTableViewerColumn(viewer, titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ClaimImpl claim = (ClaimImpl)element;
                return Utils.getPathStringFor((EObject)claim);
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private class ClickListener
    implements IDoubleClickListener {
        private ClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            EObject sel = (EObject)((StructuredSelection)event.getSelection()).getFirstElement();
            Utils.selectCDOObjectInProjectExplorer(sel);
        }
    }
}

