/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.mappings.mapping.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.opencert.infra.mappings.mapping.ComplianceMap;
import org.eclipse.opencert.infra.mappings.mapping.EquivalenceMap;
import org.eclipse.opencert.infra.mappings.mapping.Map;
import org.eclipse.opencert.infra.mappings.mapping.MapGroup;
import org.eclipse.opencert.infra.mappings.mapping.MapJustification;
import org.eclipse.opencert.infra.mappings.mapping.MapKind;
import org.eclipse.opencert.infra.mappings.mapping.MapModel;
import org.eclipse.opencert.infra.mappings.mapping.MappingFactory;
import org.eclipse.opencert.infra.mappings.mapping.MappingPackage;
import org.eclipse.opencert.infra.mappings.mapping.impl.ComplianceMapImpl;
import org.eclipse.opencert.infra.mappings.mapping.impl.EquivalenceMapImpl;
import org.eclipse.opencert.infra.mappings.mapping.impl.MapGroupImpl;
import org.eclipse.opencert.infra.mappings.mapping.impl.MapImpl;
import org.eclipse.opencert.infra.mappings.mapping.impl.MapJustificationImpl;
import org.eclipse.opencert.infra.mappings.mapping.impl.MapModelImpl;

public class MappingFactoryImpl
extends EFactoryImpl
implements MappingFactory {
    public static MappingFactory init() {
        try {
            MappingFactory theMappingFactory = (MappingFactory)EPackage.Registry.INSTANCE.getEFactory("http://mapping/1.0");
            if (theMappingFactory != null) {
                return theMappingFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new MappingFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createMapModel();
            }
            case 1: {
                return this.createMapGroup();
            }
            case 2: {
                return this.createMap();
            }
            case 3: {
                return this.createMapJustification();
            }
            case 4: {
                return this.createComplianceMap();
            }
            case 5: {
                return this.createEquivalenceMap();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createMapKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertMapKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public MapModel createMapModel() {
        MapModelImpl mapModel = new MapModelImpl();
        return mapModel;
    }

    @Override
    public MapGroup createMapGroup() {
        MapGroupImpl mapGroup = new MapGroupImpl();
        return mapGroup;
    }

    @Override
    public Map createMap() {
        MapImpl map = new MapImpl();
        return map;
    }

    @Override
    public MapJustification createMapJustification() {
        MapJustificationImpl mapJustification = new MapJustificationImpl();
        return mapJustification;
    }

    @Override
    public ComplianceMap createComplianceMap() {
        ComplianceMapImpl complianceMap = new ComplianceMapImpl();
        return complianceMap;
    }

    @Override
    public EquivalenceMap createEquivalenceMap() {
        EquivalenceMapImpl equivalenceMap = new EquivalenceMapImpl();
        return equivalenceMap;
    }

    public MapKind createMapKindFromString(EDataType eDataType, String initialValue) {
        MapKind result = MapKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertMapKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public MappingPackage getMappingPackage() {
        return (MappingPackage)this.getEPackage();
    }

    @Deprecated
    public static MappingPackage getPackage() {
        return MappingPackage.eINSTANCE;
    }
}

