/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.service.start.launcher;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.common.utilities.exception.TmLException;
import org.eclipse.tml.framework.device.model.IDeviceLauncher;
import org.eclipse.tml.service.start.exception.StartServiceExceptionHandler;

public class DeviceLauncherManager {
    public static final String LAUNCHER_ID = "org.eclipse.tml.service.start.launcher";
    public static final String ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE = "org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE";
    public static final String ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE_VALUE = "${none}";

    public static ILaunch launch(IDeviceLauncher launcher, String name) {
        ILaunch launch = null;
        try {
            BasePlugin.logInfo((String)("launching " + name));
            ILaunchManager mgr = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = mgr.getLaunchConfigurationType(LAUNCHER_ID);
            ILaunchConfigurationWorkingCopy copy = type.newInstance(null, name);
            copy.setAttribute(ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE, ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE_VALUE);
            copy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", launcher.getLocation());
            copy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", launcher.getToolArguments());
            copy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", launcher.getWorkingDirectory());
            ILaunchConfiguration config = copy.doSave();
            File file = new File(launcher.getFileId());
            if (file.exists()) {
                file.delete();
            }
            launch = config.launch("debug", null);
            launcher.setPID(DeviceLauncherManager.readPID(launcher.getFileId()));
        }
        catch (Throwable e) {
            BasePlugin.logError((String)"emulator could not be launched", (Throwable)e);
        }
        return launch;
    }

    private static int readPID(String filename) throws TmLException {
        int pid = 0;
        File file = new File(filename);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        DataInputStream dis = null;
        int count = 0;
        while (!file.exists() && count < 50) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++count;
        }
        if (count >= 50) {
            throw StartServiceExceptionHandler.exception(100);
        }
        try {
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                dis = new DataInputStream(bis);
                while (dis.available() != 0) {
                    pid = Integer.valueOf(dis.readLine());
                }
                fis.close();
                bis.close();
                dis.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                file.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
                file.delete();
            }
        }
        finally {
            file.delete();
        }
        return pid;
    }
}

