/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.device.qemuarm;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.tml.common.utilities.PluginUtils;
import org.eclipse.tml.device.qemuarm.QEmuARMPlugin;
import org.eclipse.tml.framework.device.model.IConnection;
import org.eclipse.tml.framework.device.model.IDeviceLauncher;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.service.start.launcher.DefaultConnection;

public class QEmuARMLauncher
implements IDeviceLauncher {
    public static final String SLASH = "/";
    public IConnection connection = new DefaultConnection();
    private int pid = 0;

    public QEmuARMLauncher(IInstance instance) {
        this.connection.setHost(instance.getProperties().getProperty("host"));
        this.connection.setDisplay(instance.getProperties().getProperty("display"));
        this.connection.setPort(Integer.parseInt(instance.getProperties().getProperty("port")));
    }

    public int getPID() {
        return this.pid;
    }

    public void setPID(int pid) {
        this.pid = pid;
    }

    public String getFileId() {
        return PluginUtils.getPluginInstallationPath((Plugin)QEmuARMPlugin.getDefault()).getAbsolutePath().concat(SLASH).concat("qemu").concat(SLASH).concat("qemuarm.id");
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public String getLocation() {
        String executable = null;
        executable = Platform.getOS().equals("win32") ? "qemu-arm-vnc.bat" : "qemu-arm-vnc.sh";
        return PluginUtils.getPluginInstallationPath((Plugin)QEmuARMPlugin.getDefault()).getAbsolutePath().concat(SLASH).concat("qemu").concat(SLASH).concat(executable);
    }

    public String getToolArguments() {
        return "-kernel integratorcp.zImage -pidfile qemuarm.id -initrd arm_root.img -vnc " + this.connection.getStringHost();
    }

    public String getWorkingDirectory() {
        return PluginUtils.getPluginInstallationPath((Plugin)QEmuARMPlugin.getDefault()).getAbsolutePath().concat(SLASH).concat("qemu").concat(SLASH);
    }
}

