/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.ui;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tml.linuxtools.tools.ITool;
import org.eclipse.tml.linuxtools.ui.Messages;
import org.eclipse.tml.linuxtools.utilities.ProtocolDescriptor;

public class DialogConnect
extends TitleAreaDialog {
    private final String WINDOW_TITLE = Messages.OpenConnectionDialog_Window_Title;
    private final String WINDOW_MESSAGE = Messages.OpenConnectionDialog_Window_Message;
    private final String LABEL_HOST = Messages.OpenConnectionDialog_Label_Host;
    private final String LABEL_PORT = Messages.OpenConnectionDialog_Label_Port;
    private final String LABEL_PROTOCOL = Messages.OpenConnectionDialog_Label_Protocol;
    private Text hostText;
    private Text portText;
    private Combo protocolCombo;
    private ITool tool = null;
    private List<ProtocolDescriptor> pdList = null;

    public DialogConnect(Shell parent, ITool tool) {
        super(parent);
        this.tool = tool;
        this.pdList = tool.getProtocolsDescriptors();
    }

    private int getProtocolDefaultPort(String name) {
        int retVal = -1;
        for (ProtocolDescriptor pd : this.pdList) {
            if (!pd.getName().equalsIgnoreCase(name)) continue;
            retVal = pd.getDefaultPort();
            break;
        }
        return retVal;
    }

    private ProtocolDescriptor getProcotolDescriptor(String name) {
        ProtocolDescriptor retVal = null;
        for (ProtocolDescriptor pd : this.pdList) {
            if (!pd.getName().equalsIgnoreCase(name)) continue;
            retVal = pd;
            break;
        }
        return retVal;
    }

    private String[] getProcotolsNames() {
        LinkedList<String> aux = new LinkedList<String>();
        for (ProtocolDescriptor pd : this.pdList) {
            aux.add(pd.getName());
        }
        String[] retVal = new String[1];
        retVal = aux.toArray(retVal);
        return retVal;
    }

    private void updatePortToDefault() {
        String selection = this.protocolCombo.getText();
        int port = this.getProtocolDefaultPort(selection);
        this.portText.setText(new Integer(port).toString());
    }

    protected Point getInitialSize() {
        return super.getInitialSize();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.WINDOW_TITLE);
        this.setMessage(this.WINDOW_MESSAGE);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 7;
        gridLayout.marginRight = 7;
        dialogArea.setLayout((Layout)gridLayout);
        dialogArea.setLayoutData((Object)new GridData(1808));
        dialogArea.setFont(parent.getFont());
        GridData gridData = new GridData(768);
        Label hostLabel = new Label(dialogArea, 0);
        hostLabel.setText(this.LABEL_HOST);
        this.hostText = new Text(dialogArea, 2048);
        this.hostText.setLayoutData((Object)gridData);
        Label portLabel = new Label(dialogArea, 0);
        portLabel.setText(this.LABEL_PORT);
        this.portText = new Text(dialogArea, 2048);
        this.portText.setLayoutData((Object)gridData);
        Label protocolLabel = new Label(dialogArea, 0);
        protocolLabel.setText(this.LABEL_PROTOCOL);
        this.protocolCombo = new Combo(dialogArea, 8);
        this.protocolCombo.setItems(this.getProcotolsNames());
        this.protocolCombo.select(0);
        this.updatePortToDefault();
        this.protocolCombo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                DialogConnect.this.updatePortToDefault();
            }
        });
        return dialogArea;
    }

    protected void okPressed() {
        this.tool.disconnect();
        this.tool.connect(this.hostText.getText(), new Integer(this.portText.getText()), this.getProcotolDescriptor(this.protocolCombo.getText()));
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }
}

