/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.fields;

import org.eclipse.sphinx.platform.ui.fields.BasicField;
import org.eclipse.sphinx.platform.ui.fields.ICComboField;
import org.eclipse.sphinx.platform.ui.fields.messages.FieldsMessages;
import org.eclipse.sphinx.platform.ui.internal.util.LayoutUtil;
import org.eclipse.sphinx.platform.ui.widgets.IWidgetFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CComboField
extends BasicField
implements ICComboField {
    public static String[] EMPTY_LIST = new String[]{FieldsMessages.field_EmptyListItem};
    private String fText = "";
    private int fSelectionIndex;
    private String[] fItems = new String[0];
    private CCombo fCComboControl;
    private ModifyListener fModifyListener;
    private int fStyle;

    public CComboField() {
        this(false);
    }

    public CComboField(IWidgetFactory widgetFactory) {
        this(widgetFactory, false);
    }

    public CComboField(boolean isEditable) {
        this(null, isEditable);
    }

    public CComboField(int style) {
        this(null, style);
    }

    public CComboField(IWidgetFactory widgetFactory, boolean isEditable) {
        this(widgetFactory, isEditable ? 0 : 8);
    }

    public CComboField(IWidgetFactory widgetFactory, int style) {
        super(widgetFactory);
        this.fStyle = style;
        this.fSelectionIndex = -1;
    }

    @Override
    protected Control[] doFillIntoGrid(Composite parent, int nColumns) {
        Control label = this.getLabelControl(parent, false, 1);
        CCombo combo = this.getCComboControl(parent, nColumns - 1);
        return new Control[]{label, combo};
    }

    @Override
    protected int getNumberOfControls() {
        return 2;
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fCComboControl)) {
            this.fCComboControl.setFocus();
        }
        return true;
    }

    protected final CCombo getCComboControl(Composite parent, int hspan) {
        CCombo combo = this.createComboControl(parent, hspan);
        if (combo.getLayoutData() == null) {
            if (this.fUseFormLayout) {
                combo.setLayoutData((Object)LayoutUtil.tableWrapDataForCCombo(hspan));
            } else {
                combo.setLayoutData((Object)LayoutUtil.gridDataForCCombo(hspan));
            }
        }
        return combo;
    }

    private CCombo createComboControl(Composite parent, int hspan) {
        if (this.fCComboControl == null) {
            this.assertCompositeNotNull(parent);
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CComboField.this.doModifyText(e);
                }
            };
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CComboField.this.doSelectionChanged(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            this.fCComboControl = this.fWidgetFactory != null ? this.fWidgetFactory.createCCombo(parent, this.fStyle, true, hspan) : new CCombo(parent, this.fStyle);
            this.fCComboControl.setItems(this.fItems);
            if (this.fSelectionIndex != -1) {
                this.fCComboControl.select(this.fSelectionIndex);
            } else {
                this.fCComboControl.setText(this.fText);
            }
            this.fCComboControl.setFont(parent.getFont());
            this.fCComboControl.addModifyListener(this.fModifyListener);
            this.fCComboControl.addSelectionListener(selectionListener);
            this.fCComboControl.setEnabled(this.isEnabled());
        }
        return this.fCComboControl;
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.fCComboControl)) {
            this.fText = this.fCComboControl.getText();
            this.fSelectionIndex = this.fCComboControl.getSelectionIndex();
        }
        this.dialogFieldChanged();
    }

    private void doSelectionChanged(SelectionEvent e) {
        if (this.isOkToUse((Control)this.fCComboControl)) {
            this.fItems = this.fCComboControl.getItems();
            this.fText = this.fCComboControl.getText();
            this.fSelectionIndex = this.fCComboControl.getSelectionIndex();
        }
        this.dialogFieldChanged();
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fCComboControl)) {
            this.fCComboControl.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isOkToUse((Control)this.fCComboControl)) {
            this.fCComboControl.dispose();
        }
    }

    @Override
    public String[] getItems() {
        return this.fItems;
    }

    @Override
    public void setItems(String[] items) {
        this.fItems = items;
        if (this.isOkToUse((Control)this.fCComboControl)) {
            this.fCComboControl.setItems(items);
        }
        this.dialogFieldChanged();
    }

    public String getText() {
        return this.fText;
    }

    @Override
    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fCComboControl)) {
            this.fCComboControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    @Override
    public boolean selectItem(int index) {
        boolean success = false;
        if (this.isOkToUse((Control)this.fCComboControl)) {
            this.fCComboControl.select(index);
            success = this.fCComboControl.getSelectionIndex() == index;
        } else if (index >= 0 && index < this.fItems.length) {
            this.fText = this.fItems[index];
            this.fSelectionIndex = index;
            success = true;
        }
        if (success) {
            this.dialogFieldChanged();
        }
        return success;
    }

    public boolean selectItem(String name) {
        int i = 0;
        while (i < this.fItems.length) {
            if (this.fItems[i].equals(name)) {
                return this.selectItem(i);
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getSelectionIndex() {
        if (this.isOkToUse((Control)this.fCComboControl)) {
            return this.fCComboControl.getSelectionIndex();
        }
        return this.fSelectionIndex;
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fCComboControl)) {
            this.fCComboControl.removeModifyListener(this.fModifyListener);
            this.fCComboControl.setText(text);
            this.fCComboControl.addModifyListener(this.fModifyListener);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setTextWithoutUpdate(this.fText);
    }

    @Override
    public Control getCComboControl() {
        CCombo control = null;
        if (this.isOkToUse((Control)this.fCComboControl)) {
            control = this.fCComboControl;
        }
        return control;
    }
}

