/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.internal.syncing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sphinx.emf.scoping.ResourceScopeProviderRegistry;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.emf.workspace.syncing.IModelSyncRequest;

public class ModelSyncRequest
implements IModelSyncRequest {
    private Set<IProject> projectsToLoad = Collections.synchronizedSet(new HashSet());
    private Set<IProject> loadedProjects = Collections.synchronizedSet(new HashSet());
    private Set<IProject> projectsToUnload = Collections.synchronizedSet(new HashSet());
    private Set<IProject> unloadedProjects = Collections.synchronizedSet(new HashSet());
    private Set<IProject> projectsToReload = Collections.synchronizedSet(new HashSet());
    private Set<IProject> reloadedProjects = Collections.synchronizedSet(new HashSet());
    private Set<IProject> projectsToUnresolveUnreachableCrossReferencesFor = Collections.synchronizedSet(new HashSet());
    private Set<IProject> projectsWithUnresolvedUnreachableCrossReferences = Collections.synchronizedSet(new HashSet());
    private Set<IFile> filesToLoad = Collections.synchronizedSet(new HashSet());
    private Set<IFile> loadedFiles = Collections.synchronizedSet(new HashSet());
    private Set<IFile> filesToUnload = Collections.synchronizedSet(new HashSet());
    private Set<IFile> unloadedFiles = Collections.synchronizedSet(new HashSet());
    private Set<IFile> filesToReload = Collections.synchronizedSet(new HashSet());
    private Set<IFile> reloadedFiles = Collections.synchronizedSet(new HashSet());
    private Map<IFile, IPath> filesToUpdateResourceURIFor = Collections.synchronizedMap(new HashMap());
    private Map<IFile, IPath> filesWithUpdatedResourceURI = Collections.synchronizedMap(new HashMap());

    public void init() {
    }

    public void addProjectToLoad(IProject project) {
        if (project != null) {
            if (this.projectsToUnload.contains(project)) {
                this.projectsToUnload.remove(project);
                return;
            }
            this.projectsToLoad.add(project);
            this.removeFilesToLoadFor(project);
        }
    }

    private boolean isProjectAboutToBeLoaded(IProject project) {
        return this.projectsToLoad.contains(project) || this.loadedProjects.contains(project);
    }

    public void addProjectToUnload(IProject project) {
        if (project != null) {
            if (this.projectsToLoad.contains(project)) {
                this.projectsToLoad.remove(project);
                return;
            }
            this.projectsToUnload.add(project);
            this.removeFilesToUnloadFor(project);
        }
    }

    private boolean isProjectAboutToBeUnloaded(IProject project) {
        return this.projectsToUnload.contains(project) || this.unloadedProjects.contains(project);
    }

    public void addProjectToReload(IProject project) {
        if (project != null) {
            this.projectsToReload.add(project);
            this.removeFilesToReloadFor(project);
        }
    }

    private boolean isProjectAboutToBeReloaded(IProject project) {
        return this.projectsToReload.contains(project) || this.reloadedProjects.contains(project);
    }

    public void addProjectToUnresolveUnreachableCrossReferencesFor(IProject project) {
        if (project != null && !this.isProjectWithUnreachableCrossReferencesAboutToBeUnresolved(project)) {
            this.projectsToUnresolveUnreachableCrossReferencesFor.add(project);
        }
    }

    private boolean isProjectWithUnreachableCrossReferencesAboutToBeUnresolved(IProject project) {
        return this.projectsToUnresolveUnreachableCrossReferencesFor.contains(project) || this.projectsWithUnresolvedUnreachableCrossReferences.contains(project);
    }

    public void addFileToLoad(IFile file) {
        if (file != null && !this.isProjectAboutToBeLoaded(file.getProject()) && !this.isProjectAboutToBeReloaded(file.getProject()) && file.isAccessible() && !ResourceScopeProviderRegistry.INSTANCE.isNotInAnyScope(file)) {
            this.filesToLoad.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFilesToLoadFor(IProject project) {
        if (project != null) {
            Set<IFile> set = this.filesToLoad;
            synchronized (set) {
                Iterator<IFile> iter = this.filesToLoad.iterator();
                while (iter.hasNext()) {
                    IFile file = iter.next();
                    if (!project.equals((Object)file.getProject())) continue;
                    iter.remove();
                }
            }
        }
    }

    public void addFileToUnload(IFile file) {
        if (file != null && !this.isProjectAboutToBeUnloaded(file.getProject()) && !this.isProjectAboutToBeReloaded(file.getProject()) && ResourceScopeProviderRegistry.INSTANCE.hasApplicableFileExtension(file)) {
            this.filesToUnload.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFilesToUnloadFor(IProject project) {
        if (project != null) {
            Set<IFile> set = this.filesToUnload;
            synchronized (set) {
                Iterator<IFile> iter = this.filesToUnload.iterator();
                while (iter.hasNext()) {
                    IFile file = iter.next();
                    if (!project.equals((Object)file.getProject())) continue;
                    iter.remove();
                }
            }
        }
    }

    public void addFileToReload(IFile file) {
        if (file != null && !this.isProjectAboutToBeReloaded(file.getProject()) && !ResourceScopeProviderRegistry.INSTANCE.isNotInAnyScope(file)) {
            this.filesToReload.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFilesToReloadFor(IProject project) {
        if (project != null) {
            Set<IFile> set = this.filesToReload;
            synchronized (set) {
                Iterator<IFile> iter = this.filesToReload.iterator();
                while (iter.hasNext()) {
                    IFile file = iter.next();
                    if (!project.equals((Object)file.getProject())) continue;
                    iter.remove();
                }
            }
        }
    }

    public void addFileToUpdateResourceURIFor(IFile oldFile, IPath newPath) {
        if (!ResourceScopeProviderRegistry.INSTANCE.isNotInAnyScope(oldFile)) {
            this.filesToUpdateResourceURIFor.put(oldFile, newPath);
        }
    }

    public boolean canPerform() {
        boolean canPerform = this.projectsToLoad.size() > 0 || this.projectsToUnload.size() > 0 || this.projectsToReload.size() > 0 || this.projectsToUnresolveUnreachableCrossReferencesFor.size() > 0 || this.filesToLoad.size() > 0 || this.filesToUnload.size() > 0 || this.filesToReload.size() > 0 || this.filesToUpdateResourceURIFor.size() > 0;
        return canPerform;
    }

    public void perform() {
        Cloneable files;
        HashSet<IProject> projects;
        if (!this.canPerform()) {
            return;
        }
        if (this.projectsToLoad.size() > 0) {
            projects = new HashSet<IProject>(this.projectsToLoad);
            ModelLoadManager.INSTANCE.loadProjects(projects, false, true, null);
            this.loadedProjects.addAll(this.projectsToLoad);
            this.projectsToLoad.clear();
        }
        if (this.projectsToUnload.size() > 0) {
            projects = new HashSet<IProject>(this.projectsToUnload);
            ModelLoadManager.INSTANCE.unloadProjects(projects, false, true, null);
            this.unloadedProjects.addAll(this.projectsToUnload);
            this.projectsToUnload.clear();
        }
        if (this.projectsToReload.size() > 0) {
            projects = new HashSet<IProject>(this.projectsToReload);
            ModelLoadManager.INSTANCE.reloadProjects(projects, false, true, null);
            this.reloadedProjects.addAll(this.projectsToReload);
            this.projectsToReload.clear();
        }
        if (this.projectsToUnresolveUnreachableCrossReferencesFor.size() > 0) {
            projects = new HashSet<IProject>(this.projectsToUnresolveUnreachableCrossReferencesFor);
            ModelLoadManager.INSTANCE.unresolveUnreachableCrossProjectReferences(projects, true, null);
            this.projectsWithUnresolvedUnreachableCrossReferences.addAll(this.projectsToUnresolveUnreachableCrossReferencesFor);
            this.projectsToUnresolveUnreachableCrossReferencesFor.clear();
        }
        if (this.filesToLoad.size() > 0) {
            files = new HashSet<IFile>(this.filesToLoad);
            ModelLoadManager.INSTANCE.loadFiles((Collection<IFile>)((Object)files), true, null);
            this.loadedFiles.addAll(this.filesToLoad);
            this.filesToLoad.clear();
        }
        if (this.filesToUnload.size() > 0) {
            files = new HashSet<IFile>(this.filesToUnload);
            ModelLoadManager.INSTANCE.unloadFiles((Collection<IFile>)((Object)files), false, true, null);
            this.unloadedFiles.addAll(this.filesToUnload);
            this.filesToUnload.clear();
        }
        if (this.filesToReload.size() > 0) {
            files = new HashSet<IFile>(this.filesToReload);
            ModelLoadManager.INSTANCE.reloadFiles((Collection<IFile>)((Object)files), false, true, null);
            this.reloadedFiles.addAll(this.filesToReload);
            this.filesToReload.clear();
        }
        if (this.filesToUpdateResourceURIFor.size() > 0) {
            files = new HashMap<IFile, IPath>(this.filesToUpdateResourceURIFor);
            ModelLoadManager.INSTANCE.updateResourceURIs((Map<IFile, IPath>)((Object)files), true, null);
            this.filesWithUpdatedResourceURI.putAll(this.filesToUpdateResourceURIFor);
            this.filesToUpdateResourceURIFor.clear();
        }
    }

    public void dispose() {
        this.projectsToLoad.clear();
        this.loadedProjects.clear();
        this.projectsToUnload.clear();
        this.unloadedProjects.clear();
        this.projectsToReload.clear();
        this.reloadedProjects.clear();
        this.projectsToUnresolveUnreachableCrossReferencesFor.clear();
        this.projectsWithUnresolvedUnreachableCrossReferences.clear();
        this.filesToLoad.clear();
        this.loadedFiles.clear();
        this.filesToUnload.clear();
        this.unloadedFiles.clear();
        this.filesToReload.clear();
        this.reloadedFiles.clear();
        this.filesToUpdateResourceURIFor.clear();
        this.filesWithUpdatedResourceURI.clear();
    }
}

